/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.deployment;

import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@ConfigRoot(name="cxf", phase=ConfigPhase.BUILD_TIME)
public class CxfBuildTimeConfig {
    @ConfigItem(defaultValue="/services")
    String path;
    @Deprecated(forRemoval=true)
    @ConfigItem
    Optional<List<String>> wsdlPath;
    @ConfigItem
    public CodeGenConfig codegen;
    @ConfigItem(name="java2ws")
    public Java2WsConfig java2ws;
    @ConfigItem
    public Optional<CxfClientConfig.HTTPConduitImpl> httpConduitFactory;

    @ConfigGroup
    public static class Java2WsParameterSet {
        public static final String JAVA2WS_CONFIG_KEY_PREFIX = "quarkus.cxf.java2ws";
        @ConfigItem
        public Optional<List<String>> includes;
        @ConfigItem
        public Optional<List<String>> excludes;
        @ConfigItem
        public Optional<List<String>> additionalParams;
        @ConfigItem(defaultValue="%CLASSES_DIR%/wsdl/%SIMPLE_CLASS_NAME%.wsdl")
        public String wsdlNameTemplate;

        public void validate(String prefix) {
            if (this.includes.isPresent()) {
                return;
            }
            if (this.excludes.isPresent() && this.additionalParams.isPresent()) {
                throw new IllegalStateException(prefix + ".excludes and " + prefix + ".additional-params are specified but " + prefix + ".includes are not specified. Specify some includes");
            }
            if (this.excludes.isPresent()) {
                throw new IllegalStateException(prefix + ".excludes are specified but " + prefix + ".includes are not specified. Specify some includes");
            }
            if (this.additionalParams.isPresent()) {
                throw new IllegalStateException(prefix + ".additional-params are specified but " + prefix + ".includes are not specified. Specify some includes");
            }
        }
    }

    @ConfigGroup
    public static class Java2WsConfig {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
        @ConfigItem(name="<<parent>>")
        public Java2WsParameterSet rootParameterSet;
        @ConfigItem(name="<<parent>>")
        public Map<String, Java2WsParameterSet> namedParameterSets;
    }

    @ConfigGroup
    public static class Wsdl2JavaParameterSet {
        @ConfigItem
        public Optional<List<String>> includes;
        @ConfigItem
        public Optional<List<String>> excludes;
        @ConfigItem
        public Optional<List<String>> additionalParams;
    }

    @ConfigGroup
    public static class Wsdl2JavaConfig {
        @ConfigItem(defaultValue="true")
        public boolean enabled;
        @ConfigItem(name="<<parent>>")
        public Wsdl2JavaParameterSet rootParameterSet;
        @ConfigItem(name="<<parent>>")
        public Map<String, Wsdl2JavaParameterSet> namedParameterSets;
    }

    @ConfigGroup
    public static class CodeGenConfig {
        @ConfigItem(name="wsdl2java")
        public Wsdl2JavaConfig wsdl2java;
    }
}

