/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin.internal;

import io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.internal.ComponentProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;

public class ZipkinSpanExporterComponentProvider
implements ComponentProvider<SpanExporter> {
    public Class<SpanExporter> getType() {
        return SpanExporter.class;
    }

    public String getName() {
        return "zipkin";
    }

    public SpanExporter create(DeclarativeConfigProperties config) {
        Long timeoutMs;
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeoutMs = config.getLong("timeout")) != null) {
            builder.setReadTimeout(Duration.ofMillis(timeoutMs));
        }
        return builder.build();
    }
}

