/*
 * Decompiled with CFR 0.152.
 */
package io.openapiprocessor.jackson;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.openapiprocessor.interfaces.Converter;
import io.openapiprocessor.interfaces.ConverterException;
import java.util.regex.Pattern;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JacksonConverter
implements Converter {
    private static final @UnknownKeyFor @NonNull @Initialized String CONVERT_ERROR = "failed to convert %s document.";
    private static final @UnknownKeyFor @NonNull @Initialized Pattern JSON_PATTERN = Pattern.compile("^\\s*\\{");
    private final @UnknownKeyFor @NonNull @Initialized ObjectMapper json = ((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS})).build();
    private final @UnknownKeyFor @NonNull @Initialized ObjectMapper yaml = ((YAMLMapper.Builder)YAMLMapper.builder((YAMLFactory)new YAMLFactory()).disable(new MapperFeature[]{MapperFeature.USE_ANNOTATIONS})).build();

    public @UnknownKeyFor @NonNull @Initialized Object convert(@UnknownKeyFor @NonNull @Initialized String api) throws @UnknownKeyFor @NonNull @Initialized ConverterException {
        if (JacksonConverter.isEmpty(api)) {
            throw new ConverterException(String.format(CONVERT_ERROR, "empty"));
        }
        if (this.isJson(api)) {
            return this.convertJson(api);
        }
        return this.convertYaml(api);
    }

    private @UnknownKeyFor @NonNull @Initialized Object convertJson(@UnknownKeyFor @NonNull @Initialized String api) throws @UnknownKeyFor @NonNull @Initialized ConverterException {
        try {
            return this.json.readValue(api, Object.class);
        }
        catch (Exception e) {
            throw new ConverterException(String.format(CONVERT_ERROR, "json"), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Object convertYaml(@UnknownKeyFor @NonNull @Initialized String api) throws @UnknownKeyFor @NonNull @Initialized ConverterException {
        try {
            return this.yaml.readValue(api, Object.class);
        }
        catch (Exception e) {
            throw new ConverterException(String.format(CONVERT_ERROR, "yaml"), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isJson(@UnknownKeyFor @NonNull @Initialized String source) {
        return JSON_PATTERN.matcher(source).find();
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEmpty(@UnknownKeyFor @NonNull @Initialized String source) {
        return source == null || source.isEmpty();
    }
}

