/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix.tests;

import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Socket;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;

public abstract class SocketTest<T extends Socket> {
    protected T socket;

    protected abstract T newSocket();

    @BeforeEach
    public void setup() {
        this.socket = this.newSocket();
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.socket.close();
    }

    @Test
    public void testKeepAlive() throws Exception {
        Assertions.assertFalse((boolean)this.socket.isKeepAlive());
        this.socket.setKeepAlive(true);
        Assertions.assertTrue((boolean)this.socket.isKeepAlive());
    }

    @Test
    public void testTcpNoDelay() throws Exception {
        Assertions.assertFalse((boolean)this.socket.isTcpNoDelay());
        this.socket.setTcpNoDelay(true);
        Assertions.assertTrue((boolean)this.socket.isTcpNoDelay());
    }

    @Test
    public void testReceivedBufferSize() throws Exception {
        int size = this.socket.getReceiveBufferSize();
        int newSize = 65535;
        Assertions.assertTrue((size > 0 ? 1 : 0) != 0);
        this.socket.setReceiveBufferSize(newSize);
        Assertions.assertTrue((newSize <= this.socket.getReceiveBufferSize() ? 1 : 0) != 0);
    }

    @Test
    public void testSendBufferSize() throws Exception {
        int size = this.socket.getSendBufferSize();
        int newSize = 65535;
        Assertions.assertTrue((size > 0 ? 1 : 0) != 0);
        this.socket.setSendBufferSize(newSize);
        Assertions.assertTrue((newSize <= this.socket.getSendBufferSize() ? 1 : 0) != 0);
    }

    @Test
    public void testSoLinger() throws Exception {
        Assertions.assertEquals((int)-1, (int)this.socket.getSoLinger());
        this.socket.setSoLinger(10);
        Assertions.assertEquals((int)10, (int)this.socket.getSoLinger());
    }

    @Test
    public void testDoubleCloseDoesNotThrow() throws IOException {
        Socket socket = Socket.newSocketStream();
        socket.close();
        socket.close();
    }

    @Test
    public void testTrafficClass() throws IOException {
        int value = 8;
        this.socket.setTrafficClass(8);
        Assertions.assertEquals((int)8, (int)this.socket.getTrafficClass());
    }

    @Test
    public void testIntOpt() throws IOException {
        this.socket.setReuseAddress(false);
        this.socket.setIntOpt(this.level(), this.optname(), 1);
        Assertions.assertNotEquals((int)0, (int)this.socket.getIntOpt(this.level(), this.optname()));
        this.socket.setIntOpt(this.level(), this.optname(), 0);
        Assertions.assertEquals((int)0, (int)this.socket.getIntOpt(this.level(), this.optname()));
    }

    @Test
    public void testRawOpt() throws IOException {
        ByteBuffer buffer = Buffer.allocateDirectWithNativeOrder((int)4);
        buffer.putInt(1).flip();
        this.socket.setRawOpt(this.level(), this.optname(), buffer);
        ByteBuffer out = ByteBuffer.allocate(4);
        this.socket.getRawOpt(this.level(), this.optname(), out);
        Assertions.assertFalse((boolean)out.hasRemaining());
        out.flip();
        Assertions.assertNotEquals((Object)ByteBuffer.allocate(0), (Object)out);
    }

    protected int level() {
        throw new TestAbortedException("Not supported");
    }

    protected int optname() {
        throw new TestAbortedException("Not supported");
    }
}

