/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl.ocsp;

import io.netty.handler.ssl.ocsp.IoTransport;
import io.netty.handler.ssl.ocsp.OcspClient;
import io.netty.handler.ssl.ocsp.OcspServerCertificateValidator;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.HttpsURLConnection;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class OcspClientTest {
    OcspClientTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void simpleOcspQueryTest() throws IOException, ExecutionException, InterruptedException {
        HttpURLConnection httpsConnection = null;
        try {
            URL url = new URL("https://netty.io");
            httpsConnection = (HttpsURLConnection)url.openConnection();
            httpsConnection.connect();
            X509Certificate[] certs = (X509Certificate[])((HttpsURLConnection)httpsConnection).getServerCertificates();
            X509Certificate serverCert = certs[0];
            X509Certificate certIssuer = certs[1];
            Promise promise = OcspClient.query((X509Certificate)serverCert, (X509Certificate)certIssuer, (boolean)false, (IoTransport)IoTransport.DEFAULT, (DnsNameResolver)OcspServerCertificateValidator.createDefaultResolver((IoTransport)IoTransport.DEFAULT));
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)promise.get();
            Assertions.assertNull((Object)basicOCSPResp.getResponses()[0].getCertStatus());
        }
        finally {
            if (httpsConnection != null) {
                httpsConnection.disconnect();
            }
        }
    }
}

