/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DefaultDnsPtrRecord;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRawRecord;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordDecoder;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.CharsetUtil;

public class DefaultDnsRecordDecoder
implements DnsRecordDecoder {
    protected DefaultDnsRecordDecoder() {
    }

    @Override
    public final DnsQuestion decodeQuestion(ByteBuf in) throws Exception {
        String name = this.decodeName(in);
        DnsRecordType type = DnsRecordType.valueOf(in.readUnsignedShort());
        int qClass = in.readUnsignedShort();
        return new DefaultDnsQuestion(name, type, qClass);
    }

    @Override
    public final <T extends DnsRecord> T decodeRecord(ByteBuf in) throws Exception {
        int startOffset = in.readerIndex();
        String name = this.decodeName(in);
        int endOffset = in.writerIndex();
        if (endOffset - startOffset < 10) {
            in.readerIndex(startOffset);
            return null;
        }
        DnsRecordType type = DnsRecordType.valueOf(in.readUnsignedShort());
        int aClass = in.readUnsignedShort();
        long ttl = in.readUnsignedInt();
        int length = in.readUnsignedShort();
        int offset = in.readerIndex();
        if (endOffset - offset < length) {
            in.readerIndex(startOffset);
            return null;
        }
        DnsRecord record = this.decodeRecord(name, type, aClass, ttl, in, offset, length);
        in.readerIndex(offset + length);
        return (T)record;
    }

    protected DnsRecord decodeRecord(String name, DnsRecordType type, int dnsClass, long timeToLive, ByteBuf in, int offset, int length) throws Exception {
        if (type == DnsRecordType.PTR) {
            in.setIndex(offset, offset + length);
            return new DefaultDnsPtrRecord(name, dnsClass, timeToLive, this.decodeName(in));
        }
        return new DefaultDnsRawRecord(name, type, dnsClass, timeToLive, in.duplicate().setIndex(offset, offset + length).retain());
    }

    protected String decodeName(ByteBuf in) {
        int position = -1;
        int checked = 0;
        int end = in.writerIndex();
        StringBuilder name = new StringBuilder(in.readableBytes() << 1);
        short len = in.readUnsignedByte();
        while (in.isReadable() && len != 0) {
            boolean pointer;
            boolean bl = pointer = (len & 0xC0) == 192;
            if (pointer) {
                int next;
                if (position == -1) {
                    position = in.readerIndex() + 1;
                }
                if ((next = (len & 0x3F) << 8 | in.readUnsignedByte()) >= end) {
                    throw new CorruptedFrameException("name has an out-of-range pointer");
                }
                in.readerIndex(next);
                if ((checked += 2) >= end) {
                    throw new CorruptedFrameException("name contains a loop.");
                }
            } else {
                name.append(in.toString(in.readerIndex(), (int)len, CharsetUtil.UTF_8)).append('.');
                in.skipBytes((int)len);
            }
            len = in.readUnsignedByte();
        }
        if (position != -1) {
            in.readerIndex(position);
        }
        if (name.length() == 0) {
            return "";
        }
        return name.substring(0, name.length() - 1);
    }
}

