/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledBigEndianDirectByteBufTest;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteOrder;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;

public class PooledAlignedBigEndianDirectByteBufTest
extends PooledBigEndianDirectByteBufTest {
    private static final int directMemoryCacheAlignment = 1;
    private static PooledByteBufAllocator allocator;

    @BeforeAll
    public static void setUpAllocator() {
        Assumptions.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        allocator = new PooledByteBufAllocator(true, PooledByteBufAllocator.defaultNumHeapArena(), PooledByteBufAllocator.defaultNumDirectArena(), PooledByteBufAllocator.defaultPageSize(), 11, PooledByteBufAllocator.defaultSmallCacheSize(), 64, PooledByteBufAllocator.defaultUseCacheForAllThreads(), 1);
    }

    @AfterAll
    public static void releaseAllocator() {
        allocator = null;
    }

    @Override
    protected ByteBuf alloc(int length, int maxCapacity) {
        ByteBuf buffer = allocator.directBuffer(length, maxCapacity);
        Assertions.assertSame((Object)ByteOrder.BIG_ENDIAN, (Object)buffer.order());
        return buffer;
    }
}

