/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.IntPriorityQueue;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class IntPriorityQueueTest {
    IntPriorityQueueTest() {
    }

    @Test
    public void mustThrowWhenAddingNoValue() {
        final IntPriorityQueue pq = new IntPriorityQueue();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                pq.offer(-1);
            }
        });
    }

    @Test
    public void mustReturnValuesInOrder() {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int initialValues = tlr.nextInt(5, 30);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < initialValues; ++i) {
            values.add(tlr.nextInt(0, Integer.MAX_VALUE));
        }
        IntPriorityQueue pq = new IntPriorityQueue();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        for (Integer value : values) {
            pq.offer(value.intValue());
        }
        Collections.sort(values);
        int valuesToRemove = initialValues / 2;
        ListIterator itr = values.listIterator();
        for (int i = 0; i < valuesToRemove; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)itr.hasNext());
            Assertions.assertThat((int)pq.poll()).isEqualTo(itr.next());
            itr.remove();
        }
        int moreValues = tlr.nextInt(5, 30);
        for (int i = 0; i < moreValues; ++i) {
            int value = tlr.nextInt(0, Integer.MAX_VALUE);
            pq.offer(value);
            values.add(value);
        }
        Collections.sort(values);
        itr = values.listIterator();
        while (itr.hasNext()) {
            Assertions.assertThat((int)pq.poll()).isEqualTo(itr.next());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((int)pq.poll()).isEqualTo(-1);
    }

    @Test
    public void internalRemoveOfAllElements() {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int initialValues = tlr.nextInt(5, 30);
        ArrayList<Integer> values = new ArrayList<Integer>();
        IntPriorityQueue pq = new IntPriorityQueue();
        for (int i = 0; i < initialValues; ++i) {
            int value = tlr.nextInt(0, Integer.MAX_VALUE);
            pq.offer(value);
            values.add(value);
        }
        for (Integer value : values) {
            pq.remove(value.intValue());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((int)pq.poll()).isEqualTo(-1);
    }

    @Test
    public void internalRemoveMustPreserveOrder() {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int initialValues = tlr.nextInt(1, 30);
        ArrayList<Integer> values = new ArrayList<Integer>();
        IntPriorityQueue pq = new IntPriorityQueue();
        for (int i = 0; i < initialValues; ++i) {
            int value = tlr.nextInt(0, Integer.MAX_VALUE);
            pq.offer(value);
            values.add(value);
        }
        Integer toRemove = (Integer)values.get(values.size() / 2);
        values.remove(toRemove);
        pq.remove(toRemove.intValue());
        Collections.sort(values);
        for (Integer value : values) {
            Assertions.assertThat((int)pq.poll()).isEqualTo((Object)value);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((int)pq.poll()).isEqualTo(-1);
    }

    @Test
    public void mustSupportDuplicateValues() {
        IntPriorityQueue pq = new IntPriorityQueue();
        pq.offer(10);
        pq.offer(5);
        pq.offer(6);
        pq.offer(5);
        pq.offer(10);
        pq.offer(10);
        pq.offer(6);
        pq.remove(10);
        Assertions.assertThat((int)pq.peek()).isEqualTo(5);
        Assertions.assertThat((int)pq.peek()).isEqualTo(5);
        Assertions.assertThat((int)pq.poll()).isEqualTo(5);
        Assertions.assertThat((int)pq.peek()).isEqualTo(5);
        Assertions.assertThat((int)pq.poll()).isEqualTo(5);
        Assertions.assertThat((int)pq.peek()).isEqualTo(6);
        Assertions.assertThat((int)pq.poll()).isEqualTo(6);
        Assertions.assertThat((int)pq.peek()).isEqualTo(6);
        Assertions.assertThat((int)pq.peek()).isEqualTo(6);
        Assertions.assertThat((int)pq.poll()).isEqualTo(6);
        Assertions.assertThat((int)pq.peek()).isEqualTo(10);
        Assertions.assertThat((int)pq.poll()).isEqualTo(10);
        Assertions.assertThat((int)pq.poll()).isEqualTo(10);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((int)pq.poll()).isEqualTo(-1);
        Assertions.assertThat((int)pq.peek()).isEqualTo(-1);
    }
}

