/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledHeapByteBuf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class BigEndianHeapByteBufTest
extends AbstractByteBufTest {
    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf buffer = Unpooled.buffer((int)length, (int)maxCapacity);
        Assertions.assertEquals((int)0, (int)buffer.writerIndex());
        return buffer;
    }

    @Test
    public void shouldNotAllowNullInConstructor1() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new UnpooledHeapByteBuf(null, new byte[1], 0);
            }
        });
    }

    @Test
    public void shouldNotAllowNullInConstructor2() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new UnpooledHeapByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, null, 0);
            }
        });
    }
}

