/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.WrappedByteBuf;
import io.netty.util.ResourceLeak;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;

final class AdvancedLeakAwareByteBuf
extends WrappedByteBuf {
    private static final String PROP_ACQUIRE_AND_RELEASE_ONLY = "io.netty.leakDetection.acquireAndReleaseOnly";
    private static final boolean ACQUIRE_AND_RELEASE_ONLY;
    private static final InternalLogger logger;
    private final ResourceLeak leak;

    AdvancedLeakAwareByteBuf(ByteBuf buf, ResourceLeak leak) {
        super(buf);
        this.leak = leak;
    }

    @Override
    public boolean release() {
        boolean deallocated = super.release();
        if (deallocated) {
            this.leak.close();
        } else {
            this.leak.record();
        }
        return deallocated;
    }

    @Override
    public boolean release(int decrement) {
        boolean deallocated = super.release(decrement);
        if (deallocated) {
            this.leak.close();
        } else {
            this.leak.record();
        }
        return deallocated;
    }

    private void recordLeakNonRefCountingOperation() {
        if (!ACQUIRE_AND_RELEASE_ONLY) {
            this.leak.record();
        }
    }

    @Override
    public ByteBuf order(ByteOrder endianness) {
        this.recordLeakNonRefCountingOperation();
        if (this.order() == endianness) {
            return this;
        }
        return new AdvancedLeakAwareByteBuf(super.order(endianness), this.leak);
    }

    @Override
    public ByteBuf slice() {
        this.recordLeakNonRefCountingOperation();
        return new AdvancedLeakAwareByteBuf(super.slice(), this.leak);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        this.recordLeakNonRefCountingOperation();
        return new AdvancedLeakAwareByteBuf(super.slice(index, length), this.leak);
    }

    @Override
    public ByteBuf duplicate() {
        this.recordLeakNonRefCountingOperation();
        return new AdvancedLeakAwareByteBuf(super.duplicate(), this.leak);
    }

    @Override
    public ByteBuf readSlice(int length) {
        this.recordLeakNonRefCountingOperation();
        return new AdvancedLeakAwareByteBuf(super.readSlice(length), this.leak);
    }

    @Override
    public ByteBuf discardReadBytes() {
        this.recordLeakNonRefCountingOperation();
        return super.discardReadBytes();
    }

    @Override
    public ByteBuf discardSomeReadBytes() {
        this.recordLeakNonRefCountingOperation();
        return super.discardSomeReadBytes();
    }

    @Override
    public ByteBuf ensureWritable(int minWritableBytes) {
        this.recordLeakNonRefCountingOperation();
        return super.ensureWritable(minWritableBytes);
    }

    @Override
    public int ensureWritable(int minWritableBytes, boolean force) {
        this.recordLeakNonRefCountingOperation();
        return super.ensureWritable(minWritableBytes, force);
    }

    @Override
    public boolean getBoolean(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getBoolean(index);
    }

    @Override
    public byte getByte(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getByte(index);
    }

    @Override
    public short getUnsignedByte(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getUnsignedByte(index);
    }

    @Override
    public short getShort(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getShort(index);
    }

    @Override
    public int getUnsignedShort(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getUnsignedShort(index);
    }

    @Override
    public int getMedium(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getMedium(index);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getUnsignedMedium(index);
    }

    @Override
    public int getInt(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getInt(index);
    }

    @Override
    public long getUnsignedInt(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getUnsignedInt(index);
    }

    @Override
    public long getLong(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getLong(index);
    }

    @Override
    public char getChar(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getChar(index);
    }

    @Override
    public float getFloat(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        this.recordLeakNonRefCountingOperation();
        return super.getDouble(index);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst) {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, dst);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, dst, length);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst) {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, dst);
    }

    @Override
    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, dst, dstIndex, length);
    }

    @Override
    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, dst);
    }

    @Override
    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, out, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.getBytes(index, out, length);
    }

    @Override
    public ByteBuf setBoolean(int index, boolean value) {
        this.recordLeakNonRefCountingOperation();
        return super.setBoolean(index, value);
    }

    @Override
    public ByteBuf setByte(int index, int value) {
        this.recordLeakNonRefCountingOperation();
        return super.setByte(index, value);
    }

    @Override
    public ByteBuf setShort(int index, int value) {
        this.recordLeakNonRefCountingOperation();
        return super.setShort(index, value);
    }

    @Override
    public ByteBuf setMedium(int index, int value) {
        this.recordLeakNonRefCountingOperation();
        return super.setMedium(index, value);
    }

    @Override
    public ByteBuf setInt(int index, int value) {
        this.recordLeakNonRefCountingOperation();
        return super.setInt(index, value);
    }

    @Override
    public ByteBuf setLong(int index, long value) {
        this.recordLeakNonRefCountingOperation();
        return super.setLong(index, value);
    }

    @Override
    public ByteBuf setChar(int index, int value) {
        this.recordLeakNonRefCountingOperation();
        return super.setChar(index, value);
    }

    @Override
    public ByteBuf setFloat(int index, float value) {
        this.recordLeakNonRefCountingOperation();
        return super.setFloat(index, value);
    }

    @Override
    public ByteBuf setDouble(int index, double value) {
        this.recordLeakNonRefCountingOperation();
        return super.setDouble(index, value);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src) {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, src);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, src, length);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, src, srcIndex, length);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src) {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, src);
    }

    @Override
    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, src, srcIndex, length);
    }

    @Override
    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, src);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.setBytes(index, in, length);
    }

    @Override
    public ByteBuf setZero(int index, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.setZero(index, length);
    }

    @Override
    public boolean readBoolean() {
        this.recordLeakNonRefCountingOperation();
        return super.readBoolean();
    }

    @Override
    public byte readByte() {
        this.recordLeakNonRefCountingOperation();
        return super.readByte();
    }

    @Override
    public short readUnsignedByte() {
        this.recordLeakNonRefCountingOperation();
        return super.readUnsignedByte();
    }

    @Override
    public short readShort() {
        this.recordLeakNonRefCountingOperation();
        return super.readShort();
    }

    @Override
    public int readUnsignedShort() {
        this.recordLeakNonRefCountingOperation();
        return super.readUnsignedShort();
    }

    @Override
    public int readMedium() {
        this.recordLeakNonRefCountingOperation();
        return super.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        this.recordLeakNonRefCountingOperation();
        return super.readUnsignedMedium();
    }

    @Override
    public int readInt() {
        this.recordLeakNonRefCountingOperation();
        return super.readInt();
    }

    @Override
    public long readUnsignedInt() {
        this.recordLeakNonRefCountingOperation();
        return super.readUnsignedInt();
    }

    @Override
    public long readLong() {
        this.recordLeakNonRefCountingOperation();
        return super.readLong();
    }

    @Override
    public char readChar() {
        this.recordLeakNonRefCountingOperation();
        return super.readChar();
    }

    @Override
    public float readFloat() {
        this.recordLeakNonRefCountingOperation();
        return super.readFloat();
    }

    @Override
    public double readDouble() {
        this.recordLeakNonRefCountingOperation();
        return super.readDouble();
    }

    @Override
    public ByteBuf readBytes(int length) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(length);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(dst);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(dst, length);
    }

    @Override
    public ByteBuf readBytes(ByteBuf dst, int dstIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(dst, dstIndex, length);
    }

    @Override
    public ByteBuf readBytes(byte[] dst) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(dst);
    }

    @Override
    public ByteBuf readBytes(byte[] dst, int dstIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(dst, dstIndex, length);
    }

    @Override
    public ByteBuf readBytes(ByteBuffer dst) {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(dst);
    }

    @Override
    public ByteBuf readBytes(OutputStream out, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(out, length);
    }

    @Override
    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.readBytes(out, length);
    }

    @Override
    public ByteBuf skipBytes(int length) {
        this.recordLeakNonRefCountingOperation();
        return super.skipBytes(length);
    }

    @Override
    public ByteBuf writeBoolean(boolean value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBoolean(value);
    }

    @Override
    public ByteBuf writeByte(int value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeByte(value);
    }

    @Override
    public ByteBuf writeShort(int value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeShort(value);
    }

    @Override
    public ByteBuf writeMedium(int value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeMedium(value);
    }

    @Override
    public ByteBuf writeInt(int value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeInt(value);
    }

    @Override
    public ByteBuf writeLong(long value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeLong(value);
    }

    @Override
    public ByteBuf writeChar(int value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeChar(value);
    }

    @Override
    public ByteBuf writeFloat(float value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeFloat(value);
    }

    @Override
    public ByteBuf writeDouble(double value) {
        this.recordLeakNonRefCountingOperation();
        return super.writeDouble(value);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(src);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(src, length);
    }

    @Override
    public ByteBuf writeBytes(ByteBuf src, int srcIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(src, srcIndex, length);
    }

    @Override
    public ByteBuf writeBytes(byte[] src) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(src);
    }

    @Override
    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(src, srcIndex, length);
    }

    @Override
    public ByteBuf writeBytes(ByteBuffer src) {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(src);
    }

    @Override
    public int writeBytes(InputStream in, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(in, length);
    }

    @Override
    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        this.recordLeakNonRefCountingOperation();
        return super.writeBytes(in, length);
    }

    @Override
    public ByteBuf writeZero(int length) {
        this.recordLeakNonRefCountingOperation();
        return super.writeZero(length);
    }

    @Override
    public int indexOf(int fromIndex, int toIndex, byte value) {
        this.recordLeakNonRefCountingOperation();
        return super.indexOf(fromIndex, toIndex, value);
    }

    @Override
    public int bytesBefore(byte value) {
        this.recordLeakNonRefCountingOperation();
        return super.bytesBefore(value);
    }

    @Override
    public int bytesBefore(int length, byte value) {
        this.recordLeakNonRefCountingOperation();
        return super.bytesBefore(length, value);
    }

    @Override
    public int bytesBefore(int index, int length, byte value) {
        this.recordLeakNonRefCountingOperation();
        return super.bytesBefore(index, length, value);
    }

    @Override
    public int forEachByte(ByteBufProcessor processor) {
        this.recordLeakNonRefCountingOperation();
        return super.forEachByte(processor);
    }

    @Override
    public int forEachByte(int index, int length, ByteBufProcessor processor) {
        this.recordLeakNonRefCountingOperation();
        return super.forEachByte(index, length, processor);
    }

    @Override
    public int forEachByteDesc(ByteBufProcessor processor) {
        this.recordLeakNonRefCountingOperation();
        return super.forEachByteDesc(processor);
    }

    @Override
    public int forEachByteDesc(int index, int length, ByteBufProcessor processor) {
        this.recordLeakNonRefCountingOperation();
        return super.forEachByteDesc(index, length, processor);
    }

    @Override
    public ByteBuf copy() {
        this.recordLeakNonRefCountingOperation();
        return super.copy();
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.copy(index, length);
    }

    @Override
    public int nioBufferCount() {
        this.recordLeakNonRefCountingOperation();
        return super.nioBufferCount();
    }

    @Override
    public ByteBuffer nioBuffer() {
        this.recordLeakNonRefCountingOperation();
        return super.nioBuffer();
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.nioBuffer(index, length);
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        this.recordLeakNonRefCountingOperation();
        return super.nioBuffers();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.nioBuffers(index, length);
    }

    @Override
    public ByteBuffer internalNioBuffer(int index, int length) {
        this.recordLeakNonRefCountingOperation();
        return super.internalNioBuffer(index, length);
    }

    @Override
    public String toString(Charset charset) {
        this.recordLeakNonRefCountingOperation();
        return super.toString(charset);
    }

    @Override
    public String toString(int index, int length, Charset charset) {
        this.recordLeakNonRefCountingOperation();
        return super.toString(index, length, charset);
    }

    @Override
    public ByteBuf retain() {
        this.leak.record();
        return super.retain();
    }

    @Override
    public ByteBuf retain(int increment) {
        this.leak.record();
        return super.retain(increment);
    }

    @Override
    public ByteBuf capacity(int newCapacity) {
        this.recordLeakNonRefCountingOperation();
        return super.capacity(newCapacity);
    }

    static {
        logger = InternalLoggerFactory.getInstance(AdvancedLeakAwareByteBuf.class);
        ACQUIRE_AND_RELEASE_ONLY = SystemPropertyUtil.getBoolean((String)PROP_ACQUIRE_AND_RELEASE_ONLY, (boolean)false);
        if (logger.isDebugEnabled()) {
            logger.debug("-D{}: {}", (Object)PROP_ACQUIRE_AND_RELEASE_ONLY, (Object)ACQUIRE_AND_RELEASE_ONLY);
        }
    }
}

