/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.IllegalBufferAccessException;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class AbstractReferenceCountedByteBuf
extends AbstractByteBuf {
    private static final AtomicIntegerFieldUpdater<AbstractReferenceCountedByteBuf> refCntUpdater = AtomicIntegerFieldUpdater.newUpdater(AbstractReferenceCountedByteBuf.class, "refCnt");
    private static final long REFCNT_FIELD_OFFSET;
    private volatile int refCnt = 1;

    protected AbstractReferenceCountedByteBuf(int maxCapacity) {
        super(maxCapacity);
    }

    @Override
    public final int refCnt() {
        if (REFCNT_FIELD_OFFSET >= 0L) {
            return PlatformDependent.getInt((Object)this, (long)REFCNT_FIELD_OFFSET);
        }
        return this.refCnt;
    }

    protected final void setRefCnt(int refCnt) {
        this.refCnt = refCnt;
    }

    @Override
    public ByteBuf retain() {
        int refCnt;
        do {
            if ((refCnt = this.refCnt) == 0) {
                throw new IllegalBufferAccessException();
            }
            if (refCnt != Integer.MAX_VALUE) continue;
            throw new IllegalBufferAccessException("refCnt overflow");
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt + 1));
        return this;
    }

    @Override
    public ByteBuf retain(int increment) {
        int refCnt;
        if (increment <= 0) {
            throw new IllegalArgumentException("increment: " + increment + " (expected: > 0)");
        }
        do {
            if ((refCnt = this.refCnt) == 0) {
                throw new IllegalBufferAccessException();
            }
            if (refCnt <= Integer.MAX_VALUE - increment) continue;
            throw new IllegalBufferAccessException("refCnt overflow");
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt + increment));
        return this;
    }

    @Override
    public final boolean release() {
        int refCnt;
        do {
            if ((refCnt = this.refCnt) != 0) continue;
            throw new IllegalBufferAccessException();
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt - 1));
        if (refCnt == 1) {
            this.deallocate();
            return true;
        }
        return false;
    }

    @Override
    public final boolean release(int decrement) {
        int refCnt;
        if (decrement <= 0) {
            throw new IllegalArgumentException("decrement: " + decrement + " (expected: > 0)");
        }
        do {
            if ((refCnt = this.refCnt) >= decrement) continue;
            throw new IllegalBufferAccessException();
        } while (!refCntUpdater.compareAndSet(this, refCnt, refCnt - decrement));
        if (refCnt == decrement) {
            this.deallocate();
            return true;
        }
        return false;
    }

    protected abstract void deallocate();

    static {
        long refCntFieldOffset = -1L;
        try {
            if (PlatformDependent.hasUnsafe()) {
                refCntFieldOffset = PlatformDependent.objectFieldOffset((Field)AbstractReferenceCountedByteBuf.class.getDeclaredField("refCnt"));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        REFCNT_FIELD_OFFSET = refCntFieldOffset;
    }
}

