/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractWrappedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class SlicedByteBuf
extends AbstractWrappedByteBuf {
    private final ByteBuf.Unsafe unsafe = new SlicedUnsafe();
    private final ByteBuf buffer;
    private final int adjustment;
    private final int length;

    public SlicedByteBuf(ByteBuf buffer, int index, int length) {
        super(buffer.order(), length);
        if (index < 0 || index > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index of " + index + ", maximum is " + buffer.capacity());
        }
        if (index + length > buffer.capacity()) {
            throw new IndexOutOfBoundsException("Invalid combined index of " + (index + length) + ", maximum is " + buffer.capacity());
        }
        if (buffer instanceof SlicedByteBuf) {
            this.buffer = ((SlicedByteBuf)buffer).buffer;
            this.adjustment = ((SlicedByteBuf)buffer).adjustment + index;
        } else if (buffer instanceof DuplicatedByteBuf) {
            this.buffer = ((DuplicatedByteBuf)buffer).buffer;
            this.adjustment = index;
        } else {
            this.buffer = buffer;
            this.adjustment = index;
        }
        this.length = length;
        this.writerIndex(length);
        buffer.unsafe().acquire();
    }

    @Override
    public ByteBuf unwrap() {
        return this.buffer;
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public WrappedByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("sliced buffer");
    }

    @Override
    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public int arrayOffset() {
        return this.buffer.arrayOffset() + this.adjustment;
    }

    @Override
    public byte getByte(int index) {
        this.checkIndex(index);
        return this.buffer.getByte(index + this.adjustment);
    }

    @Override
    public short getShort(int index) {
        this.checkIndex(index, 2);
        return this.buffer.getShort(index + this.adjustment);
    }

    @Override
    public int getUnsignedMedium(int index) {
        this.checkIndex(index, 3);
        return this.buffer.getUnsignedMedium(index + this.adjustment);
    }

    @Override
    public int getInt(int index) {
        this.checkIndex(index, 4);
        return this.buffer.getInt(index + this.adjustment);
    }

    @Override
    public long getLong(int index) {
        this.checkIndex(index, 8);
        return this.buffer.getLong(index + this.adjustment);
    }

    @Override
    public ByteBuf duplicate() {
        SlicedByteBuf duplicate = new SlicedByteBuf(this.buffer, this.adjustment, this.length);
        duplicate.setIndex(this.readerIndex(), this.writerIndex());
        return duplicate;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.copy(index + this.adjustment, length);
    }

    @Override
    public ByteBuf slice(int index, int length) {
        this.checkIndex(index, length);
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return new SlicedByteBuf(this.buffer, index + this.adjustment, length);
    }

    @Override
    public WrappedByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, dst, dstIndex, length);
        return this;
    }

    @Override
    public WrappedByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, dst, dstIndex, length);
        return this;
    }

    @Override
    public WrappedByteBuf getBytes(int index, ByteBuffer dst) {
        this.checkIndex(index, dst.remaining());
        this.buffer.getBytes(index + this.adjustment, dst);
        return this;
    }

    @Override
    public WrappedByteBuf setByte(int index, int value) {
        this.checkIndex(index);
        this.buffer.setByte(index + this.adjustment, value);
        return this;
    }

    @Override
    public WrappedByteBuf setShort(int index, int value) {
        this.checkIndex(index, 2);
        this.buffer.setShort(index + this.adjustment, value);
        return this;
    }

    @Override
    public WrappedByteBuf setMedium(int index, int value) {
        this.checkIndex(index, 3);
        this.buffer.setMedium(index + this.adjustment, value);
        return this;
    }

    @Override
    public WrappedByteBuf setInt(int index, int value) {
        this.checkIndex(index, 4);
        this.buffer.setInt(index + this.adjustment, value);
        return this;
    }

    @Override
    public WrappedByteBuf setLong(int index, long value) {
        this.checkIndex(index, 8);
        this.buffer.setLong(index + this.adjustment, value);
        return this;
    }

    @Override
    public WrappedByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index + this.adjustment, src, srcIndex, length);
        return this;
    }

    @Override
    public WrappedByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkIndex(index, length);
        this.buffer.setBytes(index + this.adjustment, src, srcIndex, length);
        return this;
    }

    @Override
    public WrappedByteBuf setBytes(int index, ByteBuffer src) {
        this.checkIndex(index, src.remaining());
        this.buffer.setBytes(index + this.adjustment, src);
        return this;
    }

    @Override
    public WrappedByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.checkIndex(index, length);
        this.buffer.getBytes(index + this.adjustment, out, length);
        return this;
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.getBytes(index + this.adjustment, out, length);
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index + this.adjustment, in, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        this.checkIndex(index, length);
        return this.buffer.setBytes(index + this.adjustment, in, length);
    }

    @Override
    public boolean hasNioBuffer() {
        return this.buffer.hasNioBuffer();
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.nioBuffer(index + this.adjustment, length);
    }

    @Override
    public boolean hasNioBuffers() {
        return this.buffer.hasNioBuffers();
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        this.checkIndex(index, length);
        return this.buffer.nioBuffers(index, length);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.capacity()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + ", maximum is " + this.capacity());
        }
    }

    private void checkIndex(int startIndex, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length is negative: " + length);
        }
        if (startIndex < 0) {
            throw new IndexOutOfBoundsException("startIndex cannot be negative");
        }
        if (startIndex + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Index too big - Bytes needed: " + (startIndex + length) + ", maximum is " + this.capacity());
        }
    }

    @Override
    public ByteBuf.Unsafe unsafe() {
        return this.unsafe;
    }

    private final class SlicedUnsafe
    implements ByteBuf.Unsafe {
        private SlicedUnsafe() {
        }

        @Override
        public ByteBuffer nioBuffer() {
            return SlicedByteBuf.this.buffer.nioBuffer(SlicedByteBuf.this.adjustment, SlicedByteBuf.this.length);
        }

        @Override
        public ByteBuffer[] nioBuffers() {
            return SlicedByteBuf.this.buffer.nioBuffers(SlicedByteBuf.this.adjustment, SlicedByteBuf.this.length);
        }

        @Override
        public ByteBuf newBuffer(int initialCapacity) {
            return SlicedByteBuf.this.buffer.unsafe().newBuffer(initialCapacity);
        }

        @Override
        public void discardSomeReadBytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void acquire() {
            SlicedByteBuf.this.buffer.unsafe().acquire();
        }

        @Override
        public void release() {
            SlicedByteBuf.this.buffer.unsafe().release();
        }
    }
}

