/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.http3;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.incubator.codec.http3.Http3ConnectionHandler;
import io.netty.incubator.codec.http3.Http3RequestStreamDecodeStateValidator;
import io.netty.incubator.codec.http3.Http3RequestStreamEncodeStateValidator;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.util.internal.StringUtil;

public abstract class Http3RequestStreamInitializer
extends ChannelInitializer<QuicStreamChannel> {
    protected final void initChannel(QuicStreamChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        Http3ConnectionHandler connectionHandler = (Http3ConnectionHandler)ch.parent().pipeline().get(Http3ConnectionHandler.class);
        if (connectionHandler == null) {
            throw new IllegalStateException("Couldn't obtain the " + StringUtil.simpleClassName(Http3ConnectionHandler.class) + " of the parent Channel");
        }
        Http3RequestStreamEncodeStateValidator encodeStateValidator = new Http3RequestStreamEncodeStateValidator();
        Http3RequestStreamDecodeStateValidator decodeStateValidator = new Http3RequestStreamDecodeStateValidator();
        pipeline.addLast(new ChannelHandler[]{connectionHandler.newCodec(encodeStateValidator, decodeStateValidator)});
        pipeline.addLast(new ChannelHandler[]{encodeStateValidator});
        pipeline.addLast(new ChannelHandler[]{decodeStateValidator});
        pipeline.addLast(new ChannelHandler[]{connectionHandler.newRequestStreamValidationHandler(ch, encodeStateValidator, decodeStateValidator)});
        this.initRequestStream(ch);
    }

    protected abstract void initRequestStream(QuicStreamChannel var1);
}

