/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.tracing.brave.instrument.http;

import brave.http.HttpClientHandler;
import brave.http.HttpClientRequest;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.tracing.brave.instrument.http.HttpClientTracingCorePublisher;
import io.micronaut.tracing.brave.instrument.http.HttpClientTracingPublisher;
import io.micronaut.tracing.instrument.http.OpenTracingClientFilter;
import io.micronaut.tracing.instrument.http.TracingExclusionsConfiguration;
import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import reactor.core.CorePublisher;

@Filter(value={"${tracing.http.client.path:/**}"})
@Requires(beans={HttpClientHandler.class})
@Replaces(value=OpenTracingClientFilter.class)
public class BraveTracingClientFilter
implements HttpClientFilter {
    private final HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler;
    private final HttpTracing httpTracing;
    @Nullable
    private final Predicate<String> pathExclusionTest;

    public BraveTracingClientFilter(HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler, HttpTracing httpTracing) {
        this(clientHandler, httpTracing, null);
    }

    @Inject
    public BraveTracingClientFilter(HttpClientHandler<HttpClientRequest, HttpClientResponse> clientHandler, HttpTracing httpTracing, @Nullable TracingExclusionsConfiguration exclusionsConfiguration) {
        this.clientHandler = clientHandler;
        this.httpTracing = httpTracing;
        this.pathExclusionTest = exclusionsConfiguration == null ? null : exclusionsConfiguration.exclusionTest();
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        Publisher requestPublisher = chain.proceed(request);
        if (this.shouldExclude(request.getPath())) {
            return requestPublisher;
        }
        if (requestPublisher instanceof CorePublisher) {
            return new HttpClientTracingCorePublisher(requestPublisher, request, this.clientHandler, this.httpTracing);
        }
        return new HttpClientTracingPublisher(requestPublisher, request, this.clientHandler, this.httpTracing);
    }

    private boolean shouldExclude(@Nullable String path) {
        return this.pathExclusionTest != null && path != null && this.pathExclusionTest.test(path);
    }
}

