/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.convert.format.MapFormat;
import io.micronaut.core.util.CollectionUtils;
import jakarta.inject.Singleton;
import jakarta.persistence.EntityManagerFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.SessionFactory;
import org.hibernate.stat.HibernateMetrics;

@Singleton
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.hibernate.enabled", value="true", defaultValue="true"), @Requires(classes={HibernateMetrics.class})})
public class HibernateMetricsBinder
implements BeanCreatedEventListener<EntityManagerFactory> {
    public static final String HIBERNATE_METRICS_ENABLED = "micronaut.metrics.binders.hibernate.enabled";
    private final BeanProvider<MeterRegistry> meterRegistryProvider;
    private final List<Tag> tags;

    public HibernateMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider, @Property(name="micronaut.metrics.binders.hibernate.tags") @MapFormat(transformation=MapFormat.MapTransformation.FLAT) Map<String, String> tags) {
        this.meterRegistryProvider = meterRegistryProvider;
        this.tags = CollectionUtils.isNotEmpty(tags) ? tags.entrySet().stream().map(entry -> Tag.of((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(Collectors.toList()) : Collections.emptyList();
    }

    public EntityManagerFactory onCreated(BeanCreatedEvent<EntityManagerFactory> event) {
        EntityManagerFactory entityManagerFactory = (EntityManagerFactory)event.getBean();
        String sessionFactoryName = event.getBeanIdentifier().getName();
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        if (entityManagerFactory instanceof SessionFactory) {
            HibernateMetrics.monitor((MeterRegistry)meterRegistry, (SessionFactory)((SessionFactory)entityManagerFactory), (String)sessionFactoryName, this.tags);
        }
        return entityManagerFactory;
    }
}

