/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.configures.internal;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.serviceregistry.builder.configures.StandardServiceRegistryBuilderConfigurer;
import io.micronaut.configuration.hibernate.jpa.conf.settings.SettingsSupplier;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import java.util.LinkedHashMap;
import java.util.List;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;

@Internal
@Prototype
final class SettingsConfigurer
implements StandardServiceRegistryBuilderConfigurer {
    private final List<SettingsSupplier> settingsSuppliers;

    SettingsConfigurer(List<SettingsSupplier> settingsSuppliers) {
        this.settingsSuppliers = settingsSuppliers;
    }

    @Override
    public void configure(JpaConfiguration jpaConfiguration, StandardServiceRegistryBuilder standardServiceRegistryBuilder) {
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>(jpaConfiguration.getProperties());
        settings.put("hibernate.session_factory_name", jpaConfiguration.getName());
        settings.put("hibernate.session_factory_name_is_jndi", false);
        for (SettingsSupplier settingsSupplier : this.settingsSuppliers) {
            settings.putAll(settingsSupplier.supply(jpaConfiguration));
        }
        if (CollectionUtils.isNotEmpty(settings)) {
            standardServiceRegistryBuilder.applySettings(settings);
        }
    }
}

