/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.hibernate.jpa.conf.settings.internal;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.configuration.hibernate.jpa.conf.settings.SettingsSupplier;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import java.util.Collections;
import java.util.Map;
import javax.cache.CacheManager;
import org.hibernate.cache.jcache.ConfigSettings;

@Internal
@Prototype
@Requirements(value={@Requires(classes={ConfigSettings.class, CacheManager.class}), @Requires(beans={CacheManager.class})})
final class JCacheManagerSettingSupplier
implements SettingsSupplier {
    private final CacheManager cacheManager;

    JCacheManagerSettingSupplier(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Map<String, Object> supply(JpaConfiguration jpaConfiguration) {
        jpaConfiguration.getProperties().put("hibernate.javax.cache.cache_manager", this.cacheManager);
        return Collections.singletonMap("hibernate.javax.cache.cache_manager", this.cacheManager);
    }
}

