/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.event.TokenValidatedEvent;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.reader.TokenReader;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TokenAuthenticationFetcher
implements AuthenticationFetcher {
    public static final Integer ORDER = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthenticationFetcher.class);
    protected final Collection<TokenReader> tokenReaders;
    protected final Collection<TokenValidator> tokenValidators;
    protected final ApplicationEventPublisher eventPublisher;

    public TokenAuthenticationFetcher(Collection<TokenValidator> tokenValidators, Collection<TokenReader> tokenReaders, ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.tokenValidators = tokenValidators;
        this.tokenReaders = tokenReaders;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        TokenReader tokenReader;
        String method = request.getMethod().toString();
        String path = request.getPath();
        Optional<Object> token = Optional.empty();
        Iterator<TokenReader> iterator = this.tokenReaders.iterator();
        while (iterator.hasNext() && !(token = (tokenReader = iterator.next()).findToken(request)).isPresent()) {
        }
        if (LOG.isDebugEnabled()) {
            if (token.isPresent()) {
                LOG.debug("Token {} found in request {} {}", new Object[]{token.get(), method, path});
            } else {
                LOG.debug("Unauthenticated request {}, {}, no token found.", (Object)method, (Object)path);
            }
        }
        if (!token.isPresent()) {
            return Flowable.empty();
        }
        Iterator<TokenValidator> tokenValidatorIterator = this.tokenValidators.iterator();
        String tokenString = (String)token.get();
        return this.attemptTokenValidation(request, tokenValidatorIterator, tokenString);
    }

    public int getOrder() {
        return ORDER;
    }

    private Flowable<Authentication> attemptTokenValidation(HttpRequest<?> request, Iterator<TokenValidator> tokenValidatorIterator, String tokenString) {
        if (tokenValidatorIterator.hasNext()) {
            TokenValidator tokenValidator = tokenValidatorIterator.next();
            return Flowable.just((Object)tokenString).switchMap(tokenValue -> Flowable.fromPublisher(tokenValidator.validateToken((String)tokenValue)).map(authentication -> {
                request.setAttribute(SecurityFilter.TOKEN, tokenValue);
                this.eventPublisher.publishEvent((Object)new TokenValidatedEvent(tokenValue));
                return authentication;
            })).switchIfEmpty(this.attemptTokenValidation(request, tokenValidatorIterator, tokenString));
        }
        return Flowable.empty();
    }
}

