/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.http.HttpRequest;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.management.endpoint.EndpointSensitivityProcessor;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Singleton
public class SensitiveEndpointRule
implements SecurityRule {
    public static final Integer ORDER = 0;
    protected final Map<ExecutableMethod, Boolean> endpointMethods;

    SensitiveEndpointRule(EndpointSensitivityProcessor endpointSensitivityProcessor) {
        this.endpointMethods = endpointSensitivityProcessor.getEndpointMethods();
    }

    @Override
    public SecurityRuleResult check(HttpRequest request, @Nullable RouteMatch routeMatch, @Nullable Map<String, Object> claims) {
        ExecutableMethod method;
        if (routeMatch instanceof MethodBasedRouteMatch && this.endpointMethods.containsKey(method = ((MethodBasedRouteMatch)routeMatch).getExecutableMethod())) {
            Boolean sensitive = this.endpointMethods.get(method);
            if (claims == null && sensitive.booleanValue()) {
                return SecurityRuleResult.REJECTED;
            }
            return SecurityRuleResult.ALLOWED;
        }
        return SecurityRuleResult.UNKNOWN;
    }

    public int getOrder() {
        return ORDER;
    }
}

