/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.rules;

import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.security.token.config.TokenConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractSecurityRule
implements SecurityRule {
    private final TokenConfiguration tokenConfiguration;

    AbstractSecurityRule(TokenConfiguration tokenConfiguration) {
        this.tokenConfiguration = tokenConfiguration;
    }

    protected List<String> getRoles(Map<String, Object> claims) {
        ArrayList<String> roles = new ArrayList<String>();
        if (claims == null) {
            roles.add("isAnonymous()");
        } else {
            Object rolesObject;
            if (!claims.isEmpty() && (rolesObject = claims.get(this.tokenConfiguration.getRolesName())) != null) {
                if (rolesObject instanceof Iterable) {
                    for (Object o : (Iterable)rolesObject) {
                        roles.add(o.toString());
                    }
                } else {
                    roles.add(rolesObject.toString());
                }
            }
            roles.add("isAnonymous()");
            roles.add("isAuthenticated()");
        }
        return roles;
    }

    protected SecurityRuleResult compareRoles(List<String> requiredRoles, List<String> grantedRoles) {
        requiredRoles = new ArrayList<String>(requiredRoles);
        requiredRoles.retainAll(grantedRoles);
        if (requiredRoles.isEmpty()) {
            return SecurityRuleResult.REJECTED;
        }
        return SecurityRuleResult.ALLOWED;
    }
}

