/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.filters;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilterOrderProvider;
import io.micronaut.security.handlers.RejectionHandler;
import io.micronaut.security.rules.SecurityRule;
import io.micronaut.security.rules.SecurityRuleResult;
import io.micronaut.web.router.RouteMatchUtils;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(value={"/**"})
public class SecurityFilter
extends OncePerRequestHttpServerFilter {
    public static final CharSequence AUTHENTICATION = "micronaut.AUTHENTICATION";
    public static final CharSequence TOKEN = "micronaut.TOKEN";
    private static final Logger LOG = LoggerFactory.getLogger(SecurityFilter.class);
    protected final Integer order;
    protected final Collection<SecurityRule> securityRules;
    protected final Collection<AuthenticationFetcher> authenticationFetchers;
    protected final RejectionHandler rejectionHandler;

    public SecurityFilter(Collection<SecurityRule> securityRules, Collection<AuthenticationFetcher> authenticationFetchers, RejectionHandler rejectionHandler, @Nullable SecurityFilterOrderProvider securityFilterOrderProvider) {
        this.securityRules = securityRules;
        this.authenticationFetchers = authenticationFetchers;
        this.rejectionHandler = rejectionHandler;
        this.order = securityFilterOrderProvider != null ? securityFilterOrderProvider.getOrder() : 0;
    }

    public int getOrder() {
        return this.order;
    }

    protected Publisher<MutableHttpResponse<?>> doFilterOnce(HttpRequest<?> request, ServerFilterChain chain) {
        String method = request.getMethod().toString();
        String path = request.getPath();
        Maybe authentication = Flowable.fromIterable(this.authenticationFetchers).flatMap(authenticationFetcher -> authenticationFetcher.fetchAuthentication(request)).firstElement();
        return authentication.toFlowable().flatMap(authentication1 -> {
            request.setAttribute(AUTHENTICATION, authentication1);
            Map<String, Object> attributes = authentication1.getAttributes();
            Optional routeMatch = RouteMatchUtils.findRouteMatchAtRequest((HttpRequest)request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Attributes: {}", (Object)attributes.entrySet().stream().map(entry -> (String)entry.getKey() + "=>" + entry.getValue().toString()).collect(Collectors.joining(", ")));
            }
            for (SecurityRule rule : this.securityRules) {
                SecurityRuleResult result = rule.check(request, routeMatch.orElse(null), attributes);
                if (result == SecurityRuleResult.REJECTED) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unauthorized request {} {}. The rule provider {} rejected the request.", new Object[]{method, path, rule.getClass().getName()});
                    }
                    return this.rejectionHandler.reject(request, true);
                }
                if (result != SecurityRuleResult.ALLOWED) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authorized request {} {}. The rule provider {} authorized the request.", new Object[]{method, path, rule.getClass().getName()});
                }
                return chain.proceed(request);
            }
            return this.rejectionHandler.reject(request, true);
        }).switchIfEmpty((Publisher)Flowable.just(this.securityRules).flatMap(securityRules -> {
            request.setAttribute(AUTHENTICATION, null);
            Optional routeMatch = RouteMatchUtils.findRouteMatchAtRequest((HttpRequest)request);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failure to authenticate request. {} {}.", (Object)method, (Object)path);
            }
            for (SecurityRule rule : securityRules) {
                SecurityRuleResult result = rule.check(request, routeMatch.orElse(null), null);
                if (result == SecurityRuleResult.REJECTED) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unauthorized request {} {}. The rule provider {} rejected the request.", new Object[]{method, path, rule.getClass().getName()});
                    }
                    return this.rejectionHandler.reject(request, false);
                }
                if (result != SecurityRuleResult.ALLOWED) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authorized request {} {}. The rule provider {} authorized the request.", new Object[]{method, path, rule.getClass().getName()});
                }
                return chain.proceed(request);
            }
            return this.rejectionHandler.reject(request, false);
        }));
    }
}

