/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.http.HttpMethod;
import io.micronaut.security.config.InterceptUrlMapPattern;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InterceptUrlMapConverter
implements TypeConverter<Map, InterceptUrlMapPattern> {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptUrlMapConverter.class);
    private static final String PATTERN = "pattern";
    private static final String ACCESS = "access";
    private static final String HTTP_METHOD = "httpMethod";
    private final ConversionService conversionService;

    InterceptUrlMapConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Optional<InterceptUrlMapPattern> convert(Map m, Class<InterceptUrlMapPattern> targetType, ConversionContext context) {
        if (m == null) {
            return Optional.empty();
        }
        Optional optionalPattern = this.conversionService.convert(m.get(PATTERN), String.class);
        if (optionalPattern.isPresent()) {
            Optional<List> optionalAccessList = this.conversionService.convert(m.get(ACCESS), List.class);
            if ((optionalAccessList = optionalAccessList.map(list -> list.stream().map(o -> this.conversionService.convert(o, String.class)).filter(Optional::isPresent).map(Optional::get).map(String.class::cast).collect(Collectors.toList()))).isPresent()) {
                Optional httpMethod;
                if (m.containsKey(HTTP_METHOD)) {
                    httpMethod = this.conversionService.convert(m.get(HTTP_METHOD), HttpMethod.class);
                    if (!httpMethod.isPresent()) {
                        throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to invalid %s key.", m.toString(), HTTP_METHOD));
                    }
                } else {
                    httpMethod = Optional.empty();
                }
                return Optional.of(new InterceptUrlMapPattern((String)optionalPattern.get(), optionalAccessList.get(), httpMethod.orElse(null)));
            }
            throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to missing or empty %s key.", m.toString(), ACCESS));
        }
        throw new ConfigurationException(String.format("interceptUrlMap configuration record %s rejected due to missing %s key.", m.toString(), PATTERN));
    }
}

