/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.security.authentication.AuthenticationProvider;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    protected final Collection<AuthenticationProvider> authenticationProviders;

    public Authenticator(Collection<AuthenticationProvider> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public Publisher<AuthenticationResponse> authenticate(AuthenticationRequest authenticationRequest) {
        Iterator<AuthenticationProvider> providerIterator;
        if (this.authenticationProviders == null) {
            return Flowable.empty();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.authenticationProviders.stream().map(Object::getClass).map(Class::getName).collect(Collectors.joining()));
        }
        if ((providerIterator = this.authenticationProviders.iterator()).hasNext()) {
            Flowable providerFlowable = Flowable.just((Object)providerIterator.next());
            AtomicReference<AuthenticationResponse> lastFailure = new AtomicReference<AuthenticationResponse>();
            return this.attemptAuthenticationRequest(authenticationRequest, providerIterator, (Flowable<AuthenticationProvider>)providerFlowable, lastFailure);
        }
        return Flowable.empty();
    }

    private Flowable<AuthenticationResponse> attemptAuthenticationRequest(AuthenticationRequest authenticationRequest, Iterator<AuthenticationProvider> providerIterator, Flowable<AuthenticationProvider> providerFlowable, AtomicReference<AuthenticationResponse> lastFailure) {
        return providerFlowable.switchMap(authenticationProvider -> {
            Flowable responseFlowable = Flowable.fromPublisher(authenticationProvider.authenticate(authenticationRequest));
            Flowable authenticationAttemptFlowable = responseFlowable.switchMap(authenticationResponse -> {
                if (authenticationResponse.isAuthenticated()) {
                    return Flowable.just((Object)authenticationResponse);
                }
                if (providerIterator.hasNext()) {
                    lastFailure.set((AuthenticationResponse)authenticationResponse);
                    return this.attemptAuthenticationRequest(authenticationRequest, providerIterator, (Flowable<AuthenticationProvider>)Flowable.just(providerIterator.next()), lastFailure);
                }
                lastFailure.set((AuthenticationResponse)authenticationResponse);
                return Flowable.just((Object)authenticationResponse);
            });
            return authenticationAttemptFlowable.onErrorResumeNext(throwable -> {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Authentication provider threw exception", throwable);
                }
                if (providerIterator.hasNext()) {
                    return this.attemptAuthenticationRequest(authenticationRequest, providerIterator, (Flowable<AuthenticationProvider>)Flowable.just(providerIterator.next()), lastFailure);
                }
                AuthenticationResponse lastFailureResponse = (AuthenticationResponse)lastFailure.get();
                if (lastFailureResponse != null) {
                    return Flowable.just((Object)lastFailureResponse);
                }
                return Flowable.empty();
            });
        });
    }
}

