/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce.session;

import io.lettuce.core.Range;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.BaseRedisAsyncCommands;
import io.lettuce.core.api.async.RedisHashAsyncCommands;
import io.lettuce.core.api.async.RedisKeyAsyncCommands;
import io.lettuce.core.api.async.RedisSortedSetAsyncCommands;
import io.lettuce.core.api.async.RedisStringAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.api.sync.RedisServerCommands;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubAsyncCommandsImpl;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.RedisPubSubReactiveCommandsImpl;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.micronaut.configuration.lettuce.RedisConnectionUtil;
import io.micronaut.configuration.lettuce.session.RedisHttpSessionConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.serialize.ObjectSerializer;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.session.InMemorySession;
import io.micronaut.session.InMemorySessionStore;
import io.micronaut.session.Session;
import io.micronaut.session.SessionIdGenerator;
import io.micronaut.session.SessionStore;
import io.micronaut.session.event.SessionCreatedEvent;
import io.micronaut.session.event.SessionDeletedEvent;
import io.micronaut.session.event.SessionExpiredEvent;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Primary
@Requires(property="micronaut.session.http.redis.enabled", value="true")
@Replaces(value=InMemorySessionStore.class)
@TypeHint(value={RedisPubSubAsyncCommandsImpl.class, RedisPubSubReactiveCommandsImpl.class}, accessType={TypeHint.AccessType.ALL_PUBLIC})
public class RedisSessionStore
extends RedisPubSubAdapter<String, String>
implements SessionStore<RedisSession>,
AutoCloseable {
    public static final String REDIS_SESSION_ENABLED = "micronaut.session.http.redis.enabled";
    private static final int EXPIRATION_SECONDS = 5;
    private static final Logger LOG = LoggerFactory.getLogger(RedisSessionStore.class);
    private final RedisHttpSessionConfiguration sessionConfiguration;
    private final SessionIdGenerator sessionIdGenerator;
    private final ConversionService conversionService;
    private final ApplicationEventPublisher eventPublisher;
    private final ObjectSerializer valueSerializer;
    private final Charset charset;
    private final String expiryPrefix;
    private final byte[] sessionCreatedTopic;
    private final byte[] activeSessionsSet;
    private final RedisHttpSessionConfiguration.WriteMode writeMode;
    private final StatefulConnection<byte[], byte[]> connection;
    private final BaseRedisAsyncCommands<byte[], byte[]> baseRedisAsyncCommands;
    private final RedisServerCommands<byte[], byte[]> redisServerCommands;
    private final RedisSortedSetAsyncCommands<byte[], byte[]> redisSortedSetAsyncCommands;
    private final RedisStringAsyncCommands<byte[], byte[]> redisStringAsyncCommands;
    private final RedisHashAsyncCommands<byte[], byte[]> redisHashAsyncCommands;
    private final RedisKeyAsyncCommands<byte[], byte[]> redisKeyAsyncCommands;

    public RedisSessionStore(SessionIdGenerator sessionIdGenerator, RedisHttpSessionConfiguration sessionConfiguration, BeanLocator beanLocator, ObjectSerializer defaultSerializer, ConversionService conversionService, @Named(value="scheduled") ExecutorService scheduledExecutorService, ApplicationEventPublisher eventPublisher) {
        block11: {
            RedisCommands sync;
            this.writeMode = sessionConfiguration.getWriteMode();
            this.sessionIdGenerator = sessionIdGenerator;
            this.conversionService = conversionService;
            this.valueSerializer = sessionConfiguration.getValueSerializer().flatMap(arg_0 -> ((BeanLocator)beanLocator).findOrInstantiateBean(arg_0)).orElse(defaultSerializer);
            this.eventPublisher = eventPublisher;
            this.sessionConfiguration = sessionConfiguration;
            this.charset = sessionConfiguration.getCharset();
            StatefulRedisPubSubConnection<String, String> pubSubConnection = this.findRedisPubSubConnection(sessionConfiguration, beanLocator);
            this.expiryPrefix = sessionConfiguration.getNamespace() + "expiry:";
            this.sessionCreatedTopic = sessionConfiguration.getSessionCreatedTopic().getBytes(this.charset);
            this.activeSessionsSet = sessionConfiguration.getActiveSessionsKey().getBytes(this.charset);
            pubSubConnection.addListener((RedisPubSubListener)this);
            this.connection = RedisConnectionUtil.openBytesRedisConnection(beanLocator, sessionConfiguration.getServerName(), "No Redis server configured to store sessions");
            if (this.connection instanceof StatefulRedisConnection) {
                this.redisServerCommands = sync = ((StatefulRedisConnection)this.connection).sync();
                this.baseRedisAsyncCommands = async = ((StatefulRedisConnection)this.connection).async();
                this.redisSortedSetAsyncCommands = async;
                this.redisStringAsyncCommands = async;
                this.redisHashAsyncCommands = async;
                this.redisKeyAsyncCommands = async;
            } else if (this.connection instanceof StatefulRedisClusterConnection) {
                this.redisServerCommands = sync = ((StatefulRedisClusterConnection)this.connection).sync();
                this.baseRedisAsyncCommands = async = ((StatefulRedisClusterConnection)this.connection).async();
                this.redisSortedSetAsyncCommands = async;
                this.redisStringAsyncCommands = async;
                this.redisHashAsyncCommands = async;
                this.redisKeyAsyncCommands = async;
            } else {
                throw new ConfigurationException("Invalid Redis connection");
            }
            sync = pubSubConnection.sync();
            try {
                sync.psubscribe((Object[])new String[]{"__keyevent@*:del", "__keyevent@*:expired"});
                sync.subscribe((Object[])new String[]{sessionConfiguration.getSessionCreatedTopic()});
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to subscribe to session topics: " + e.getMessage(), (Throwable)e);
            }
            if (sessionConfiguration.isEnableKeyspaceEvents()) {
                try {
                    String result = this.redisServerCommands.configSet("notify-keyspace-events", "Egx");
                    if (!result.equalsIgnoreCase("ok") && LOG.isWarnEnabled()) {
                        LOG.warn("Failed to enable keyspace events on the Redis server. Manual configuration my be required");
                    }
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn("Failed to enable keyspace events on the Redis server. Manual configuration my be required", (Throwable)e);
                }
            }
        }
        if (!(scheduledExecutorService instanceof ScheduledExecutorService)) {
            throw new ConfigurationException("Configured scheduled executor service is not an instanceof ScheduledExecutorService");
        }
        long checkDelayMillis = sessionConfiguration.getExpiredSessionCheck().toMillis();
        ((ScheduledExecutorService)scheduledExecutorService).scheduleAtFixedRate(() -> {
            long oneMinuteFromNow = Instant.now().plus(1L, ChronoUnit.MINUTES).toEpochMilli();
            long oneMinuteAgo = Instant.now().minus(1L, ChronoUnit.MINUTES).toEpochMilli();
            this.redisSortedSetAsyncCommands.zrangebyscore((Object)this.activeSessionsSet, Range.create((Object)Long.valueOf(oneMinuteAgo).doubleValue(), (Object)Long.valueOf(oneMinuteFromNow).doubleValue())).thenAccept(aboutToExpire -> {
                if (aboutToExpire != null) {
                    for (byte[] bytes : aboutToExpire) {
                        byte[] expiryKey = this.getExpiryKey(new String(bytes, this.charset));
                        this.redisStringAsyncCommands.get((Object)expiryKey);
                    }
                }
            });
        }, checkDelayMillis, checkDelayMillis, TimeUnit.MILLISECONDS);
    }

    public ObjectSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public void message(String channel, String message) {
        if (channel.equals(this.sessionConfiguration.getSessionCreatedTopic())) {
            this.findSessionInternal(message, false).whenComplete((optional, throwable) -> {
                if (throwable == null && optional.isPresent()) {
                    RedisSession session = (RedisSession)((Object)((Object)optional.get()));
                    this.eventPublisher.publishEvent((Object)new SessionCreatedEvent((Session)session));
                }
            });
        }
    }

    public void message(String pattern, String channel, String message) {
        if (message.startsWith(this.expiryPrefix)) {
            boolean expired = pattern.endsWith(":expired");
            if (pattern.endsWith(":del") || expired) {
                String id = message.substring(this.expiryPrefix.length());
                this.redisSortedSetAsyncCommands.zrem((Object)this.activeSessionsSet, (Object[])new byte[][]{id.getBytes(this.charset)}).whenComplete((aVoid, throwable) -> {
                    if (throwable != null && LOG.isErrorEnabled()) {
                        LOG.error("Error removing session [" + id + "] from active sessions: " + throwable.getMessage(), throwable);
                    }
                });
                this.findSessionInternal(id, true).whenComplete((optional, throwable) -> {
                    if (throwable == null && optional.isPresent()) {
                        RedisSession session = (RedisSession)((Object)((Object)optional.get()));
                        this.eventPublisher.publishEvent(expired ? new SessionExpiredEvent((Session)session) : new SessionDeletedEvent((Session)session));
                    }
                });
            }
        }
    }

    public RedisSession newSession() {
        return new RedisSession(this.sessionIdGenerator.generateId(), this.valueSerializer, this.sessionConfiguration.getMaxInactiveInterval());
    }

    public CompletableFuture<Optional<RedisSession>> findSession(String id) {
        return this.findSessionInternal(id, false).thenApply(session -> {
            session.ifPresent(redisSession -> redisSession.setLastAccessedTime(Instant.now()));
            return session;
        });
    }

    public CompletableFuture<Boolean> deleteSession(String id) {
        return ((CompletableFuture)this.findSessionInternal(id, true).thenCompose(session -> {
            if (session.isPresent()) {
                RedisSession redisSession = (RedisSession)((Object)((Object)session.get()));
                redisSession.setMaxInactiveInterval(Duration.ZERO);
                return this.save(redisSession).thenApply(ignore -> true);
            }
            return CompletableFuture.completedFuture(false);
        })).toCompletableFuture();
    }

    public CompletableFuture<RedisSession> save(RedisSession session) {
        Map<byte[], byte[]> changes = session.delta(this.charset);
        if (changes.isEmpty()) {
            return CompletableFuture.completedFuture(session);
        }
        Set<String> removedKeys = session.removedKeys;
        byte[][] removedKeyBytes = (byte[][])removedKeys.stream().map(str -> ("attr:" + str).getBytes(this.charset)).toArray(x$0 -> new byte[x$0][]);
        if (!removedKeys.isEmpty()) {
            byte[] sessionKey = this.getSessionKey(session.getId());
            return this.redisHashAsyncCommands.hdel((Object)sessionKey, (Object[])removedKeyBytes).thenCompose(ignore -> this.saveSessionDelta(session, changes)).toCompletableFuture();
        }
        return this.saveSessionDelta(session, changes);
    }

    private CompletableFuture<RedisSession> saveSessionDelta(RedisSession session, Map<byte[], byte[]> changes) {
        Duration maxInactiveInterval = session.getMaxInactiveInterval();
        long expirySeconds = maxInactiveInterval.getSeconds();
        byte[] sessionKey = this.getSessionKey(session.getId());
        byte[] sessionIdBytes = session.getId().getBytes(this.charset);
        if (expirySeconds == 0L) {
            RedisFuture deleteOp = this.redisKeyAsyncCommands.del((Object[])new byte[][]{this.getExpiryKey(session)});
            return deleteOp.thenCompose(ignore -> this.redisHashAsyncCommands.hmset((Object)sessionKey, changes)).thenApply(ignore -> session).toCompletableFuture();
        }
        return this.redisHashAsyncCommands.hmset((Object)sessionKey, changes).thenCompose(ignore -> {
            block4: {
                try {
                    if (session.isNew()) {
                        session.clearModifications();
                        this.baseRedisAsyncCommands.publish((Object)this.sessionCreatedTopic, (Object)sessionIdBytes).whenComplete((aLong, throwable12) -> {
                            if (throwable12 != null && LOG.isErrorEnabled()) {
                                LOG.error("Error publishing session creation event: " + throwable12.getMessage(), throwable12);
                            }
                        });
                    } else {
                        session.clearModifications();
                    }
                }
                catch (Throwable e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error("Error publishing session creation event: " + e.getMessage(), e);
                }
            }
            long fiveMinutesAfterExpires = expirySeconds + TimeUnit.MINUTES.toSeconds(5L);
            byte[] expiryKey = this.getExpiryKey(session);
            double expireTimeScore = Long.valueOf(Instant.now().plus(expirySeconds, ChronoUnit.SECONDS).toEpochMilli()).doubleValue();
            CompletableFuture expireOp = this.redisKeyAsyncCommands.expire((Object)sessionKey, fiveMinutesAfterExpires).toCompletableFuture();
            CompletableFuture saveExpiryOp = this.redisStringAsyncCommands.setex((Object)expiryKey, expirySeconds, (Object)String.valueOf(expirySeconds).getBytes()).toCompletableFuture();
            CompletableFuture saveActiveSessionOp = this.redisSortedSetAsyncCommands.zadd((Object)this.activeSessionsSet, expireTimeScore, (Object)sessionIdBytes).toCompletableFuture();
            return CompletableFuture.allOf(expireOp, saveExpiryOp, saveActiveSessionOp).thenApply(ignore2 -> session);
        }).toCompletableFuture();
    }

    private byte[] getExpiryKey(RedisSession session) {
        String id = session.getId();
        return this.getExpiryKey(id);
    }

    private byte[] getExpiryKey(String id) {
        return (this.expiryPrefix + id).getBytes();
    }

    private CompletableFuture<Optional<RedisSession>> findSessionInternal(String id, boolean allowExpired) {
        return this.redisHashAsyncCommands.hgetall((Object)this.getSessionKey(id)).thenApply(data -> {
            Map<String, byte[]> transformed;
            RedisSession session;
            if (CollectionUtils.isNotEmpty((Map)data) && (!(session = new RedisSession(id, this.valueSerializer, transformed = data.entrySet().stream().collect(Collectors.toMap(entry -> new String((byte[])entry.getKey(), this.charset), Map.Entry::getValue)))).isExpired() || allowExpired)) {
                return Optional.of(session);
            }
            return Optional.empty();
        }).toCompletableFuture();
    }

    private byte[] getSessionKey(String id) {
        return (this.sessionConfiguration.getNamespace() + "sessions:" + id).getBytes();
    }

    private StatefulRedisPubSubConnection<String, String> findRedisPubSubConnection(RedisHttpSessionConfiguration sessionConfiguration, BeanLocator beanLocator) {
        Optional<String> serverName = sessionConfiguration.getServerName();
        return (StatefulRedisPubSubConnection)serverName.map(name -> beanLocator.findBean(StatefulRedisPubSubConnection.class, Qualifiers.byName((String)name)).map(conn -> conn).orElse((StatefulConnection)beanLocator.findBean(StatefulRedisPubSubConnection.class, Qualifiers.byName((String)name)).orElseThrow(() -> new ConfigurationException("No Redis server configured to store sessions")))).orElseGet(() -> beanLocator.findBean(StatefulRedisPubSubConnection.class).map(conn -> conn).orElse((StatefulConnection)beanLocator.findBean(StatefulRedisPubSubConnection.class).orElseThrow(() -> new ConfigurationException("No Redis server configured to store sessions"))));
    }

    private static Instant readLastAccessTimed(Map<String, byte[]> data) {
        return RedisSessionStore.readInstant(data, "Last-Accessed");
    }

    private static Duration readMaxInactive(Map<String, byte[]> data) {
        byte[] value;
        if (data != null && (value = data.get("Max-Inactive-Interval")) != null) {
            try {
                Long seconds = Long.valueOf(new String(value));
                return Duration.ofSeconds(seconds);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Instant readCreationTime(Map<String, byte[]> data) {
        return RedisSessionStore.readInstant(data, "Creation-Time");
    }

    private static Instant readInstant(Map<String, byte[]> data, String attr) {
        byte[] value;
        if (data != null && (value = data.get(attr)) != null) {
            try {
                Long millis = Long.valueOf(new String(value));
                return Instant.ofEpochMilli(millis);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Instant.now();
    }

    @Override
    @PreDestroy
    public void close() {
        this.connection.close();
    }

    class RedisSession
    extends InMemorySession
    implements Session {
        static final String ATTR_CREATION_TIME = "Creation-Time";
        static final String ATTR_LAST_ACCESSED = "Last-Accessed";
        static final String ATTR_MAX_INACTIVE_INTERVAL = "Max-Inactive-Interval";
        static final String ATTR_PREFIX = "attr:";
        final Set<String> removedKeys;
        final Set<String> modifiedKeys;
        private final Set<Modification> modifications;
        private final ObjectSerializer valueSerializer;

        RedisSession(String id, ObjectSerializer valueSerializer, Duration maxInactiveInterval) {
            super(id, Instant.now(), maxInactiveInterval);
            this.removedKeys = new HashSet<String>(2);
            this.modifiedKeys = new HashSet<String>(2);
            this.modifications = new HashSet<Modification>();
            this.valueSerializer = valueSerializer;
            this.modifications.add(Modification.CREATED);
        }

        RedisSession(String id, ObjectSerializer valueSerializer, Map<String, byte[]> data) {
            super(id, RedisSessionStore.readCreationTime(data), RedisSessionStore.readMaxInactive(data));
            this.removedKeys = new HashSet<String>(2);
            this.modifiedKeys = new HashSet<String>(2);
            this.modifications = new HashSet<Modification>();
            this.valueSerializer = valueSerializer;
            this.lastAccessTime = RedisSessionStore.readLastAccessTimed(data);
            for (String name : data.keySet()) {
                if (!name.startsWith(ATTR_PREFIX)) continue;
                String attrName = name.substring(ATTR_PREFIX.length());
                this.attributeMap.put(attrName, data.get(name));
            }
        }

        public boolean isModified() {
            return !this.modifications.isEmpty();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            return super.get(name, ConversionContext.of(Object.class)).flatMap(o -> {
                if (o instanceof byte[]) {
                    byte[] rawBytes = (byte[])o;
                    return this.valueSerializer.deserialize(rawBytes, conversionContext.getArgument());
                }
                return RedisSessionStore.this.conversionService.convert(o, conversionContext);
            });
        }

        public Optional<Object> get(CharSequence attr) {
            Object val;
            Optional result = super.get(attr);
            if (result.isPresent() && (val = result.get()) instanceof byte[]) {
                Optional deserialized = this.valueSerializer.deserialize((byte[])val);
                deserialized.ifPresent(t -> this.attributeMap.put(attr, t));
                return deserialized;
            }
            return result;
        }

        public Session setLastAccessedTime(Instant instant) {
            if (instant != null) {
                if (!this.isNew()) {
                    this.modifications.add(Modification.ADDITION);
                }
                if (RedisSessionStore.this.writeMode == RedisHttpSessionConfiguration.WriteMode.BACKGROUND) {
                    byte[] lastAccessedTimeBytes = String.valueOf(instant.toEpochMilli()).getBytes();
                    this.writeBehind(ATTR_LAST_ACCESSED, lastAccessedTimeBytes);
                }
            }
            return super.setLastAccessedTime(instant);
        }

        public Session setMaxInactiveInterval(Duration duration) {
            if (duration != null) {
                if (!this.isNew()) {
                    this.modifications.add(Modification.ADDITION);
                }
                if (RedisSessionStore.this.writeMode == RedisHttpSessionConfiguration.WriteMode.BACKGROUND) {
                    byte[] intervalBytes = String.valueOf(this.getMaxInactiveInterval().getSeconds()).getBytes();
                    this.writeBehind(ATTR_MAX_INACTIVE_INTERVAL, intervalBytes);
                }
            }
            return super.setMaxInactiveInterval(duration);
        }

        public MutableConvertibleValues<Object> put(CharSequence key, Object value) {
            if (value == null) {
                return this.remove(key);
            }
            if (key != null && !this.isNew()) {
                this.modifications.add(Modification.ADDITION);
                String attr = key.toString();
                this.modifiedKeys.add(attr);
                if (RedisSessionStore.this.writeMode == RedisHttpSessionConfiguration.WriteMode.BACKGROUND) {
                    byte[] bytes;
                    byte[] byArray = bytes = value instanceof byte[] ? (byte[])value : (byte[])this.valueSerializer.serialize(value).orElse(null);
                    if (bytes != null) {
                        this.writeBehind(ATTR_PREFIX + attr, bytes);
                    }
                }
            }
            return super.put(key, value);
        }

        public MutableConvertibleValues<Object> remove(CharSequence key) {
            if (key != null && !this.isNew()) {
                this.modifications.add(Modification.REMOVAL);
                String attr = key.toString();
                this.removedKeys.add(attr);
                if (RedisSessionStore.this.writeMode == RedisHttpSessionConfiguration.WriteMode.BACKGROUND) {
                    RedisSessionStore.this.redisHashAsyncCommands.hdel((Object)RedisSessionStore.this.getSessionKey(this.getId()), (Object[])new byte[][]{this.getAttributeKey(attr)}).exceptionally(this.attributeErrorHandler(attr));
                }
            }
            this.modifications.add(Modification.REMOVAL);
            return super.remove(key);
        }

        private byte[] getAttributeKey(String attr) {
            return (ATTR_PREFIX + attr).getBytes(RedisSessionStore.this.charset);
        }

        public MutableConvertibleValues<Object> clear() {
            if (!this.isNew()) {
                this.modifications.add(Modification.CLEARED);
                Set names = this.names();
                this.removedKeys.addAll(names);
                if (RedisSessionStore.this.writeMode == RedisHttpSessionConfiguration.WriteMode.BACKGROUND) {
                    byte[][] attributes = (byte[][])names.stream().map(this::getAttributeKey).toArray(x$0 -> new byte[x$0][]);
                    RedisSessionStore.this.redisHashAsyncCommands.hdel((Object)RedisSessionStore.this.getSessionKey(this.getId()), (Object[])attributes).exceptionally(throwable -> {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error writing behind session attributes: " + throwable.getMessage(), throwable);
                        }
                        return null;
                    });
                }
            }
            return super.clear();
        }

        public boolean isNew() {
            return this.modifications.contains((Object)Modification.CREATED);
        }

        Map<byte[], byte[]> delta(Charset charset) {
            if (this.modifications.isEmpty()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<byte[], byte[]> delta = new LinkedHashMap<byte[], byte[]>();
            if (this.isNew()) {
                byte[] creationTimeBytes = String.valueOf(this.getCreationTime().toEpochMilli()).getBytes();
                delta.put(ATTR_CREATION_TIME.getBytes(charset), creationTimeBytes);
                Instant instant = this.getLastAccessedTime();
                byte[] lastAccessedTimeBytes = String.valueOf(instant.toEpochMilli()).getBytes();
                delta.put(ATTR_LAST_ACCESSED.getBytes(charset), lastAccessedTimeBytes);
                delta.put(ATTR_MAX_INACTIVE_INTERVAL.getBytes(charset), String.valueOf(this.getMaxInactiveInterval().getSeconds()).getBytes());
                for (CharSequence key : this.attributeMap.keySet()) {
                    this.convertAttribute(key, delta, charset);
                }
            } else {
                delta.put(ATTR_LAST_ACCESSED.getBytes(charset), String.valueOf(this.getLastAccessedTime().toEpochMilli()).getBytes());
                delta.put(ATTR_MAX_INACTIVE_INTERVAL.getBytes(charset), String.valueOf(this.getMaxInactiveInterval().getSeconds()).getBytes());
                for (CharSequence charSequence : this.modifiedKeys) {
                    this.convertAttribute(charSequence, delta, charset);
                }
            }
            return delta;
        }

        void clearModifications() {
            this.modifications.clear();
            this.removedKeys.clear();
            this.modifiedKeys.clear();
        }

        private <T> Function<Throwable, T> attributeErrorHandler(String attr) {
            return throwable -> {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error writing behind session attribute [" + attr + "]: " + throwable.getMessage(), throwable);
                }
                return null;
            };
        }

        private void writeBehind(String attr, byte[] lastAccessedTimeBytes) {
            RedisSessionStore.this.redisHashAsyncCommands.hset((Object)RedisSessionStore.this.getSessionKey(this.getId()), (Object)attr.getBytes(RedisSessionStore.this.charset), (Object)lastAccessedTimeBytes).exceptionally(this.attributeErrorHandler(attr));
        }

        private void convertAttribute(CharSequence key, Map<byte[], byte[]> delta, Charset charset) {
            Object rawValue = this.attributeMap.get(key);
            byte[] attributeKey = this.getAttributeKey(key.toString());
            if (rawValue instanceof byte[]) {
                delta.put(attributeKey, (byte[])rawValue);
            } else if (rawValue != null) {
                Optional serialized = this.valueSerializer.serialize(rawValue);
                serialized.ifPresent(bytes -> delta.put(attributeKey, (byte[])bytes));
            }
        }
    }

    static enum Modification {
        CREATED,
        CLEARED,
        ADDITION,
        REMOVAL;

    }
}

