/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.metrics.CommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerCommandLatencyRecorder;
import io.lettuce.core.metrics.MicrometerOptions;
import io.lettuce.core.resource.ClientResources;
import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;

@Singleton
@Requires(beans={MeterRegistry.class})
public class MetricsClientResourceMutator
implements ClientResourcesMutator {
    private final MeterRegistry meterRegistry;

    public MetricsClientResourceMutator(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void mutate(ClientResources.Builder builder, AbstractRedisConfiguration config) {
        MicrometerOptions options = MicrometerOptions.builder().histogram(true).build();
        builder.commandLatencyRecorder((CommandLatencyRecorder)new MicrometerCommandLatencyRecorder(this.meterRegistry, options));
    }
}

