/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.lettuce;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.resource.ClientResources;
import io.micronaut.configuration.lettuce.AbstractRedisClientFactory;
import io.micronaut.configuration.lettuce.AbstractRedisConfiguration;
import io.micronaut.configuration.lettuce.ClientResourcesMutator;
import io.micronaut.configuration.lettuce.DefaultRedisConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

@Requirements(value={@Requires(beans={DefaultRedisConfiguration.class}), @Requires(missingProperty="redis.uris")})
@Singleton
@Factory
public class DefaultRedisClientFactory<K, V>
extends AbstractRedisClientFactory<K, V> {
    public DefaultRedisClientFactory(@Primary RedisCodec<K, V> codec) {
        super(codec);
    }

    @Override
    @Bean(preDestroy="shutdown")
    @Singleton
    @Primary
    public RedisClient redisClient(@Primary AbstractRedisConfiguration config, @Nullable @Primary ClientResources defaultClientResources, @Nullable List<ClientResourcesMutator> mutators) {
        return super.redisClient(config, defaultClientResources, mutators);
    }

    @Bean(preDestroy="close")
    @Singleton
    @Primary
    public StatefulRedisConnection<K, V> redisConnection(@Primary RedisClient redisClient, AbstractRedisConfiguration config) {
        if (config.getUri().isPresent() && !config.getReplicaUris().isEmpty()) {
            ArrayList<RedisURI> uris = new ArrayList<RedisURI>(config.getReplicaUris());
            uris.add(config.getUri().get());
            StatefulRedisMasterReplicaConnection connection = MasterReplica.connect((RedisClient)redisClient, (RedisCodec)this.defaultCodec, uris);
            if (config.getReadFrom().isPresent()) {
                connection.setReadFrom(config.getReadFrom().get());
            }
            return connection;
        }
        return super.redisConnection(redisClient, this.defaultCodec);
    }

    @Deprecated(since="6.5.0", forRemoval=true)
    public StatefulRedisConnection<K, V> redisConnection(@Primary RedisClient redisClient) {
        return super.redisConnection(redisClient, this.defaultCodec);
    }

    @Bean(preDestroy="close")
    @Singleton
    public StatefulRedisPubSubConnection<K, V> redisPubSubConnection(@Primary RedisClient redisClient) {
        return super.redisPubSubConnection(redisClient, this.defaultCodec);
    }
}

