/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.connect;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.event.BeanPreDestroyEvent;
import io.micronaut.context.event.BeanPreDestroyEventListener;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.rabbitmq.connect.RabbitConnectionFactoryConfig;
import io.micronaut.rabbitmq.connect.recovery.TemporarilyDownConnectionManager;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.ConnectException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Factory
public class RabbitConnectionFactory
implements BeanPreDestroyEventListener<ExecutorService> {
    private static final Logger LOG = LoggerFactory.getLogger(RabbitConnectionFactory.class);
    private final ConcurrentLinkedQueue<ActiveConnection> activeConnections = new ConcurrentLinkedQueue();

    @Deprecated(since="4.2.0", forRemoval=true)
    Connection connection(RabbitConnectionFactoryConfig connectionFactory, BeanContext beanContext) {
        return this.connection(connectionFactory, (TemporarilyDownConnectionManager)beanContext.getBean(TemporarilyDownConnectionManager.class), beanContext);
    }

    @Singleton
    @EachBean(value=RabbitConnectionFactoryConfig.class)
    Connection connection(RabbitConnectionFactoryConfig connectionFactory, TemporarilyDownConnectionManager temporarilyDownConnectionManager, BeanContext beanContext) {
        try {
            ExecutorService executorService = (ExecutorService)beanContext.getBean(ExecutorService.class, Qualifiers.byName((String)connectionFactory.getConsumerExecutor()));
            Connection connection = this.newConnection(connectionFactory, temporarilyDownConnectionManager, executorService);
            this.activeConnections.add(new ActiveConnection(connection, connectionFactory, executorService));
            return connection;
        }
        catch (IOException | TimeoutException e) {
            throw new BeanInstantiationException("Error creating connection to RabbitMQ", (Throwable)e);
        }
    }

    private Connection newConnection(RabbitConnectionFactoryConfig factory, TemporarilyDownConnectionManager temporarilyDownConnectionManager, ExecutorService executorService) throws IOException, TimeoutException {
        Optional<List<Address>> addresses = factory.getAddresses();
        try {
            if (addresses.isPresent()) {
                return factory.newConnection(executorService, addresses.get());
            }
            return factory.newConnection(executorService);
        }
        catch (ConnectException e) {
            if (factory.isAutomaticRecoveryEnabled()) {
                return temporarilyDownConnectionManager.newConnection(factory, executorService);
            }
            throw e;
        }
    }

    @PreDestroy
    void shutdownConnections() {
        try {
            this.activeConnections.forEach(ActiveConnection::tryClose);
        }
        finally {
            this.activeConnections.clear();
        }
    }

    @NonNull
    public ExecutorService onPreDestroy(@NonNull BeanPreDestroyEvent<ExecutorService> event) {
        this.activeConnections.stream().filter(activeConnection -> activeConnection.executorService() == event.getBean()).forEach(ActiveConnection::tryClose);
        this.activeConnections.removeIf(activeConnection -> !activeConnection.connection().isOpen());
        return (ExecutorService)event.getBean();
    }

    private record ActiveConnection(Connection connection, RabbitConnectionFactoryConfig connectionFactory, ExecutorService executorService) {
        private void tryClose() {
            Connection connection = this.connection();
            if (connection.isOpen()) {
                try {
                    connection.close(this.connectionFactory().getShutdownTimeout());
                }
                catch (Exception e) {
                    LOG.warn("Error closing RabbitMQ connection: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

