/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.rabbitmq.bind;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.messaging.annotation.MessageBody;
import io.micronaut.rabbitmq.bind.RabbitAnnotatedArgumentBinder;
import io.micronaut.rabbitmq.bind.RabbitConsumerState;
import io.micronaut.rabbitmq.serdes.RabbitMessageSerDesRegistry;
import jakarta.inject.Singleton;
import java.util.Optional;

@Singleton
public class RabbitBodyBinder
implements RabbitAnnotatedArgumentBinder<MessageBody> {
    private final RabbitMessageSerDesRegistry serDesRegistry;

    public RabbitBodyBinder(RabbitMessageSerDesRegistry serDesRegistry) {
        this.serDesRegistry = serDesRegistry;
    }

    public Class<MessageBody> getAnnotationType() {
        return MessageBody.class;
    }

    public ArgumentBinder.BindingResult<Object> bind(ArgumentConversionContext<Object> context, RabbitConsumerState messageState) {
        Argument bodyType = context.getArgument();
        Optional<Object> message = this.serDesRegistry.findSerdes(bodyType).map(serDes -> serDes.deserialize(messageState, bodyType));
        return () -> message;
    }
}

