/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.swagger.core.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.swagger.v3.oas.models.callbacks.Callback;
import java.io.IOException;
import java.util.Map;

public class CallbackSerializer
extends JsonSerializer<Callback> {
    public void serialize(Callback value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null && value.getExtensions() != null && !value.getExtensions().isEmpty()) {
            jgen.writeStartObject();
            if (value.get$ref() == null || value.get$ref().isBlank()) {
                if (!value.isEmpty()) {
                    for (Map.Entry entry : value.entrySet()) {
                        jgen.writeObjectField((String)entry.getKey(), entry.getValue());
                    }
                }
            } else {
                jgen.writeStringField("$ref", value.get$ref());
            }
            for (String ext : value.getExtensions().keySet()) {
                jgen.writeObjectField(ext, value.getExtensions().get(ext));
            }
            jgen.writeEndObject();
        } else if (value == null || value.get$ref() == null || value.get$ref().isBlank()) {
            provider.defaultSerializeValue((Object)value, jgen);
        } else {
            jgen.writeStartObject();
            jgen.writeStringField("$ref", value.get$ref());
            jgen.writeEndObject();
        }
    }
}

