/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.databind;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.reflect.InstantiationUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.ObjectMapperFactory;
import io.micronaut.jackson.codec.JacksonFeatures;
import io.micronaut.jackson.core.parser.JacksonCoreParserFactory;
import io.micronaut.jackson.core.parser.JacksonCoreProcessor;
import io.micronaut.jackson.core.tree.JsonNodeTreeCodec;
import io.micronaut.jackson.core.tree.TreeGenerator;
import io.micronaut.jackson.serialize.JsonNodeDeserializer;
import io.micronaut.jackson.serialize.JsonNodeSerializer;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapper;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.JsonSyntaxException;
import io.micronaut.json.tree.JsonNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;

@Internal
@Singleton
@BootstrapContextCompatible
public final class JacksonDatabindMapper
implements JsonMapper {
    private final ObjectMapper objectMapper;
    private final JsonStreamConfig config;
    private final JsonNodeTreeCodec treeCodec;
    private final ObjectReader specializedReader;
    private final ObjectWriter specializedWriter;

    @Inject
    @Internal
    public JacksonDatabindMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.config = JsonStreamConfig.DEFAULT.withUseBigDecimalForFloats(objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)).withUseBigIntegerForInts(objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS));
        this.treeCodec = JsonNodeTreeCodec.getInstance().withConfig(this.config);
        this.specializedReader = null;
        this.specializedWriter = null;
    }

    @Internal
    public JacksonDatabindMapper() {
        this(JacksonDatabindMapper.createDefaultMapper());
    }

    private JacksonDatabindMapper(JacksonDatabindMapper from, Argument<?> type) {
        this.objectMapper = from.objectMapper;
        this.config = from.config;
        this.treeCodec = from.treeCodec;
        this.specializedReader = from.createReader(type);
        this.specializedWriter = from.createWriter(type);
    }

    private static ObjectMapper createDefaultMapper() {
        ObjectMapperFactory objectMapperFactory = new ObjectMapperFactory();
        objectMapperFactory.setDeserializers(new JsonNodeDeserializer());
        objectMapperFactory.setSerializers(new JsonNodeSerializer());
        return objectMapperFactory.objectMapper(null, null);
    }

    @Internal
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public JsonMapper createSpecific(Argument<?> type) {
        return new JacksonDatabindMapper(this, type);
    }

    private ObjectReader createReader(@NonNull Argument<?> type) {
        if (this.specializedReader != null) {
            return this.specializedReader;
        }
        ObjectReader reader = this.objectMapper.readerFor(JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
        Optional view = type.getAnnotationMetadata().classValue(JsonView.class);
        if (view.isPresent()) {
            reader = reader.withView((Class)view.get());
        }
        return reader;
    }

    private ObjectWriter createWriter(@NonNull Argument<?> type) {
        if (this.specializedWriter != null) {
            return this.specializedWriter;
        }
        ObjectWriter writer = this.objectMapper.writerFor(JacksonConfiguration.constructType(type, this.objectMapper.getTypeFactory()));
        Optional view = type.getAnnotationMetadata().classValue(JsonView.class);
        if (view.isPresent()) {
            writer = writer.withView((Class)view.get());
        }
        return writer;
    }

    public <T> T readValueFromTree(@NonNull JsonNode tree, @NonNull Argument<T> type) throws IOException {
        return (T)this.createReader(type).readValue(this.treeAsTokens(tree));
    }

    @NonNull
    public JsonNode writeValueToTree(@Nullable Object value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        treeGenerator.setCodec((ObjectCodec)this.objectMapper);
        this.objectMapper.writeValue((JsonGenerator)treeGenerator, value);
        return treeGenerator.getCompletedValue();
    }

    @NonNull
    public <T> JsonNode writeValueToTree(@NonNull Argument<T> type, T value) throws IOException {
        TreeGenerator treeGenerator = this.treeCodec.createTreeGenerator();
        treeGenerator.setCodec((ObjectCodec)this.objectMapper);
        this.createWriter(type).writeValue((JsonGenerator)treeGenerator, value);
        return treeGenerator.getCompletedValue();
    }

    public <T> T readValue(@NonNull InputStream inputStream, @NonNull Argument<T> type) throws IOException {
        try {
            return (T)this.createReader(type).readValue(inputStream);
        }
        catch (JsonParseException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    public <T> T readValue(@NonNull byte[] byteArray, @NonNull Argument<T> type) throws IOException {
        try {
            return (T)this.createReader(type).readValue(byteArray);
        }
        catch (JsonParseException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T readValue(ByteBuffer<?> byteBuffer, Argument<T> type) throws IOException {
        try (JsonParser parser = JacksonCoreParserFactory.createJsonParser((JsonFactory)this.objectMapper.getFactory(), byteBuffer);){
            Object object = this.createReader(type).readValue(parser);
            return (T)object;
        }
        catch (JsonParseException pe) {
            throw new JsonSyntaxException((Throwable)pe);
        }
    }

    public void writeValue(@NonNull OutputStream outputStream, @Nullable Object object) throws IOException {
        this.objectMapper.writeValue(outputStream, object);
    }

    public <T> void writeValue(@NonNull OutputStream outputStream, @NonNull Argument<T> type, T object) throws IOException {
        this.createWriter(type).writeValue(outputStream, object);
    }

    public byte[] writeValueAsBytes(@Nullable Object object) throws IOException {
        return this.objectMapper.writeValueAsBytes(object);
    }

    public <T> byte[] writeValueAsBytes(@NonNull Argument<T> type, T object) throws IOException {
        return this.createWriter(type).writeValueAsBytes(object);
    }

    public void updateValueFromTree(Object value, @NonNull JsonNode tree) throws IOException {
        this.objectMapper.readerForUpdating(value).readValue(this.treeAsTokens(tree));
    }

    @NonNull
    public JsonMapper cloneWithFeatures(@NonNull JsonFeatures features) {
        JacksonFeatures jacksonFeatures = (JacksonFeatures)features;
        ObjectMapper objectMapper = this.objectMapper.copy();
        jacksonFeatures.getDeserializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        jacksonFeatures.getSerializationFeatures().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        for (Class<? extends Module> moduleClass : jacksonFeatures.getAdditionalModules()) {
            objectMapper.registerModule((Module)InstantiationUtils.instantiate(moduleClass));
        }
        return new JacksonDatabindMapper(objectMapper);
    }

    @NonNull
    public JsonMapper cloneWithViewClass(@NonNull Class<?> viewClass) {
        ObjectMapper objectMapper = this.objectMapper.copy();
        objectMapper.setConfig(objectMapper.getSerializationConfig().withView(viewClass));
        objectMapper.setConfig(objectMapper.getDeserializationConfig().withView(viewClass));
        return new JacksonDatabindMapper(objectMapper);
    }

    @NonNull
    public JsonStreamConfig getStreamConfig() {
        return this.config;
    }

    @NonNull
    public Processor<byte[], JsonNode> createReactiveParser(final @NonNull Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        return new JacksonCoreProcessor(streamArray, this.objectMapper.getFactory(), this.config){

            public void subscribe(Subscriber<? super JsonNode> downstreamSubscriber) {
                onSubscribe.accept(this);
                super.subscribe(downstreamSubscriber);
            }
        };
    }

    @NonNull
    public Optional<JsonFeatures> detectFeatures(@NonNull AnnotationMetadata annotations) {
        return Optional.ofNullable(annotations.getAnnotation(io.micronaut.jackson.annotation.JacksonFeatures.class)).map(JacksonFeatures::fromAnnotation);
    }

    private JsonParser treeAsTokens(@NonNull JsonNode tree) {
        JsonParser parser = this.treeCodec.treeAsTokens(tree);
        parser.setCodec((ObjectCodec)this.objectMapper);
        return parser;
    }
}

