/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ArrayableClassElement;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.GenericElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.ast.annotation.WildcardElementAnnotationMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
final class GroovyWildcardElement
extends GroovyClassElement
implements WildcardElement {
    private final GroovyNativeElement wildcardNativeElement;
    private final GroovyClassElement upperType;
    private final List<GroovyClassElement> upperBounds;
    private final List<GroovyClassElement> lowerBounds;
    private final ElementAnnotationMetadata typeAnnotationMetadata;
    @Nullable
    private ElementAnnotationMetadata genericTypeAnnotationMetadata;

    GroovyWildcardElement(@NonNull GroovyNativeElement wildcardNativeElement, @NonNull List<GroovyClassElement> upperBounds, @NonNull List<GroovyClassElement> lowerBounds, @NonNull ElementAnnotationMetadataFactory annotationMetadataFactory, @NonNull GroovyClassElement upperType) {
        super(upperType.visitorContext, upperType.getNativeType(), annotationMetadataFactory, upperType.getTypeArguments(), 0);
        this.wildcardNativeElement = wildcardNativeElement;
        this.upperType = upperType;
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
        this.typeAnnotationMetadata = new WildcardElementAnnotationMetadata((WildcardElement)this, (ClassElement)upperType);
    }

    public Optional<ClassElement> getResolved() {
        return Optional.of(this.upperType);
    }

    @NonNull
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getGenericTypeAnnotationMetadata() {
        if (this.genericTypeAnnotationMetadata == null) {
            this.genericTypeAnnotationMetadata = this.elementAnnotationMetadataFactory.buildGenericTypeAnnotations((GenericElement)this);
        }
        return this.genericTypeAnnotationMetadata;
    }

    @Override
    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.getGenericTypeAnnotationMetadata();
    }

    @Override
    @NonNull
    public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        return this.typeAnnotationMetadata;
    }

    @Override
    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        return new AnnotationMetadataHierarchy(true, new AnnotationMetadata[]{super.getAnnotationMetadata(), this.getGenericTypeAnnotationMetadata()});
    }

    @NonNull
    public Object getGenericNativeType() {
        return this.wildcardNativeElement;
    }

    @Override
    @NonNull
    protected GroovyClassElement copyConstructor() {
        return new GroovyWildcardElement(this.wildcardNativeElement, this.upperBounds, this.lowerBounds, this.elementAnnotationMetadataFactory, this.upperType);
    }

    @NonNull
    public List<? extends ClassElement> getUpperBounds() {
        return this.upperBounds;
    }

    @NonNull
    public List<? extends ClassElement> getLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        if (arrayDimensions != 0) {
            throw new UnsupportedOperationException("Can't create array of wildcard");
        }
        return this;
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        List<GroovyClassElement> upperBounds = this.upperBounds.stream().map(ele -> this.toGroovyClassElement(ele.foldBoundGenericTypes(fold))).collect(Collectors.toList());
        List<GroovyClassElement> lowerBounds = this.lowerBounds.stream().map(ele -> this.toGroovyClassElement(ele.foldBoundGenericTypes(fold))).collect(Collectors.toList());
        return fold.apply((ClassElement)(upperBounds.contains(null) || lowerBounds.contains(null) ? null : new GroovyWildcardElement(this.wildcardNativeElement, upperBounds, lowerBounds, this.elementAnnotationMetadataFactory, this.upperType)));
    }

    private GroovyClassElement toGroovyClassElement(ClassElement element) {
        if (element == null || element instanceof GroovyClassElement) {
            return (GroovyClassElement)element;
        }
        if (element.isWildcard() || element.isGenericPlaceholder()) {
            throw new UnsupportedOperationException("Cannot convert wildcard / free type variable to GroovyClassElement");
        }
        return (GroovyClassElement)((ArrayableClassElement)this.visitorContext.getClassElement(element.getName(), this.elementAnnotationMetadataFactory).orElseThrow(() -> new UnsupportedOperationException("Cannot convert ClassElement to GroovyClassElement, class was not found on the visitor context"))).withArrayDimensions(element.getArrayDimensions()).withTypeArguments((Collection)element.getBoundGenericTypes());
    }
}

