/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyEnumConstantElement;
import io.micronaut.ast.groovy.visitor.GroovyNativeElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.EnumConstantElement;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.FieldNode;

@Internal
class GroovyEnumElement
extends GroovyClassElement
implements EnumElement {
    protected List<EnumConstantElement> enumConstants;
    protected List<String> values;

    GroovyEnumElement(GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory) {
        this(visitorContext, nativeElement, annotationMetadataFactory, 0);
    }

    GroovyEnumElement(GroovyVisitorContext visitorContext, GroovyNativeElement nativeElement, ElementAnnotationMetadataFactory annotationMetadataFactory, int arrayDimensions) {
        super(visitorContext, nativeElement, annotationMetadataFactory, null, arrayDimensions);
    }

    public List<String> values() {
        if (this.values != null) {
            return this.values;
        }
        this.initEnum();
        return this.values;
    }

    public List<EnumConstantElement> elements() {
        if (this.enumConstants != null) {
            return this.enumConstants;
        }
        this.initEnum();
        return this.enumConstants;
    }

    private void initEnum() {
        this.values = new ArrayList<String>();
        this.enumConstants = new ArrayList<EnumConstantElement>();
        for (FieldNode field : this.classNode.getFields()) {
            if (field.getName().equals("MAX_VALUE") || field.getName().equals("MIN_VALUE") || !field.isEnum()) continue;
            this.values.add(field.getName());
            this.enumConstants.add(new GroovyEnumConstantElement(this, this.visitorContext, field, this.elementAnnotationMetadataFactory));
        }
        this.values = Collections.unmodifiableList(this.values);
        this.enumConstants = Collections.unmodifiableList(this.enumConstants);
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyEnumElement(this.visitorContext, this.getNativeType(), this.elementAnnotationMetadataFactory, arrayDimensions);
    }
}

