/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.utils;

import io.micronaut.ast.groovy.utils.InMemoryByteCodeGroovyClassLoader;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class InMemoryClassWriterOutputVisitor
implements ClassWriterOutputVisitor {
    private final Map<String, ByteArrayOutputStream> classStreams = new LinkedHashMap<String, ByteArrayOutputStream>();
    private final Map<String, Set<String>> serviceDescriptors = new LinkedHashMap<String, Set<String>>();
    private final InMemoryByteCodeGroovyClassLoader classLoader;

    public InMemoryClassWriterOutputVisitor(InMemoryByteCodeGroovyClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public OutputStream visitClass(String classname, Element ... originatingElements) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.classStreams.put(classname, stream);
        return stream;
    }

    public final void visitServiceDescriptor(String type, String classname) {
        if (StringUtils.isNotEmpty((CharSequence)type) && StringUtils.isNotEmpty((CharSequence)classname)) {
            this.serviceDescriptors.computeIfAbsent(type, s -> new LinkedHashSet()).add(classname);
        }
    }

    public void visitServiceDescriptor(String type, String classname, Element originatingElement) {
        if (StringUtils.isNotEmpty((CharSequence)type) && StringUtils.isNotEmpty((CharSequence)classname)) {
            this.serviceDescriptors.computeIfAbsent(type, s -> new LinkedHashSet()).add(classname);
        }
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path, Element ... originatingElements) {
        return Optional.empty();
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return Optional.empty();
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path, Element ... originatingElements) {
        return Optional.empty();
    }

    public void finish() {
        this.classStreams.forEach((name, stream) -> this.classLoader.addClass((String)name, stream.toByteArray()));
        this.classStreams.clear();
        this.serviceDescriptors.forEach((name, files) -> {
            try {
                this.classLoader.addService((String)name, (Set<String>)files);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        });
        this.serviceDescriptors.clear();
    }
}

