/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.scan;

import io.micronaut.ast.groovy.scan.AnnotatedTypeInfoVisitor;
import io.micronaut.ast.groovy.scan.AnnotationClassReader;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.scan.AnnotationScanner;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClassPathAnnotationScanner
implements AnnotationScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathAnnotationScanner.class);
    private final ClassLoader classLoader;
    private boolean includeJars;

    public ClassPathAnnotationScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.includeJars = true;
    }

    public ClassPathAnnotationScanner() {
        this(ClassPathAnnotationScanner.class.getClassLoader());
    }

    protected ClassPathAnnotationScanner includeJars(boolean includeJars) {
        this.includeJars = includeJars;
        return this;
    }

    @NonNull
    public Stream<Class<?>> scan(@NonNull String annotation, @NonNull String pkg) {
        if (pkg == null) {
            return Stream.empty();
        }
        List<Class<?>> classes = this.doScan(annotation, pkg);
        return classes.stream();
    }

    protected List<Class<?>> doScan(String annotation, String pkg) {
        try {
            String packagePath = pkg.replace('.', '/').concat("/");
            ArrayList classes = new ArrayList();
            Enumeration<URL> resources = this.classLoader.getResources(packagePath);
            if (!resources.hasMoreElements() && LOG.isDebugEnabled()) {
                LOG.debug("No resources found under package path: {}", (Object)packagePath);
            }
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    try {
                        this.traverseFile(annotation, classes, Paths.get(url.toURI()));
                    }
                    catch (URISyntaxException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Ignoring file [{}] due to URI error: {}", new Object[]{url, e.getMessage(), e});
                    }
                    continue;
                }
                if (!this.includeJars || !Arrays.asList("jar", "zip", "war").contains(protocol)) continue;
                URLConnection con = url.openConnection();
                if (con instanceof JarURLConnection) {
                    JarURLConnection jarCon = (JarURLConnection)con;
                    JarFile jarFile = jarCon.getJarFile();
                    jarFile.stream().filter(entry -> {
                        String name = entry.getName();
                        return name.startsWith(packagePath) && name.endsWith(".class") && name.indexOf(36) == -1;
                    }).forEach(entry -> {
                        block10: {
                            try (InputStream inputStream = jarFile.getInputStream((ZipEntry)entry);){
                                this.scanInputStream(annotation, inputStream, classes);
                            }
                            catch (IOException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Ignoring JAR entry [{}] due to I/O error: {}", new Object[]{entry.getName(), e.getMessage(), e});
                                }
                            }
                            catch (ClassNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break block10;
                                LOG.debug("Ignoring JAR entry [{}]. Class not found: {}", new Object[]{entry.getName(), e.getMessage(), e});
                            }
                        }
                    });
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring JAR URI entry [{}]. No JarURLConnection found.", (Object)url);
            }
            return classes;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring I/O Exception scanning package: {}", (Object)pkg, (Object)e);
            }
            return Collections.emptyList();
        }
    }

    protected void traverseFile(String annotation, List<Class<?>> classes, Path filePath) {
        block10: {
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                try (DirectoryStream<Path> dirs = Files.newDirectoryStream(filePath);){
                    dirs.forEach(path -> {
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            this.traverseFile(annotation, classes, (Path)path);
                        } else {
                            this.scanFile(annotation, (Path)path, classes);
                        }
                    });
                    break block10;
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring directory [{}] due to I/O error: {}", new Object[]{filePath, e.getMessage(), e});
                    }
                    break block10;
                }
            }
            this.scanFile(annotation, filePath, classes);
        }
    }

    protected void scanFile(String annotation, Path filePath, List<Class<?>> classes) {
        block11: {
            String fileName = filePath.getFileName().toString();
            if (fileName.endsWith(".class") && fileName.indexOf(36) == -1) {
                try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                    this.scanInputStream(annotation, inputStream, classes);
                }
                catch (IOException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring file [{}] due to I/O error: {}", new Object[]{fileName, e.getMessage(), e});
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug("Ignoring file [{}]. Class not found: {}", new Object[]{fileName, e.getMessage(), e});
                }
            }
        }
    }

    private void scanInputStream(String annotation, InputStream inputStream, List<Class<?>> classes) throws IOException, ClassNotFoundException {
        AnnotationClassReader annotationClassReader = new AnnotationClassReader(inputStream);
        AnnotatedTypeInfoVisitor classVisitor = new AnnotatedTypeInfoVisitor();
        annotationClassReader.accept(classVisitor, 2);
        if (classVisitor.hasAnnotation(annotation)) {
            classes.add(this.classLoader.loadClass(classVisitor.getTypeName()));
        }
    }
}

