/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.bind;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ConversionError;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@Internal
final class MappedBindingResult<T, R>
implements ArgumentBinder.BindingResult<R> {
    private final ArgumentBinder.BindingResult<T> source;
    private final Function<T, ArgumentBinder.BindingResult<R>> function;
    private ArgumentBinder.BindingResult<R> second;

    MappedBindingResult(ArgumentBinder.BindingResult<T> source, Function<T, ArgumentBinder.BindingResult<R>> function) {
        this.source = source;
        this.function = function;
    }

    private ArgumentBinder.BindingResult<R> computeSecond() {
        if (this.second == null) {
            Optional<T> first = this.source.getValue();
            this.second = first.isPresent() ? this.function.apply(first.get()) : this.source;
        }
        return this.second;
    }

    @Override
    public List<ConversionError> getConversionErrors() {
        List<ConversionError> conversionErrors = this.source.getConversionErrors();
        if (conversionErrors.isEmpty() && this.source.isSatisfied()) {
            conversionErrors = this.computeSecond().getConversionErrors();
        }
        return conversionErrors;
    }

    @Override
    public boolean isSatisfied() {
        return this.source.isSatisfied() && this.computeSecond().isSatisfied();
    }

    @Override
    public Optional<R> getValue() {
        return this.computeSecond().getValue();
    }
}

