/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.grpc.server;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.grpc.server.GrpcEmbeddedServer;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@Requires(beans={GrpcEmbeddedServer.class})
class GrpcEmbeddedServerListener
implements ApplicationEventListener<ServerStartupEvent>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcEmbeddedServerListener.class);
    private final BeanContext beanContext;
    private GrpcEmbeddedServer grpcServer;

    GrpcEmbeddedServerListener(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public void onApplicationEvent(ServerStartupEvent event) {
        EmbeddedServer server = event.getSource();
        if (!(server instanceof GrpcEmbeddedServer)) {
            this.grpcServer = (GrpcEmbeddedServer)this.beanContext.getBean(GrpcEmbeddedServer.class);
            this.grpcServer.start();
            if (LOG.isInfoEnabled()) {
                LOG.info("GRPC started on port {}", (Object)this.grpcServer.getPort());
            }
        }
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.grpcServer != null && this.grpcServer.isRunning()) {
            this.grpcServer.stop();
        }
    }
}

