/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.jpa.annotation.EntityGraph;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersStoredQuery;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.FlushModeType;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.SubGraph;

@Internal
public abstract class AbstractHibernateOperations<S, Q>
implements HintsCapableRepository,
PreparedQueryDecorator,
StoredQueryDecorator {
    private static final JpaQueryBuilder QUERY_BUILDER = new JpaQueryBuilder();
    private static final String ENTITY_GRAPH_FETCH = "javax.persistence.fetchgraph";
    private static final String ENTITY_GRAPH_LOAD = "javax.persistence.loadgraph";
    protected final ConversionService<?> dataConversionService;
    protected final RuntimeEntityRegistry runtimeEntityRegistry;

    protected AbstractHibernateOperations(RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> dataConversionService) {
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.dataConversionService = dataConversionService == null ? ConversionService.SHARED : dataConversionService;
    }

    public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
        return new DefaultBindableParametersPreparedQuery(preparedQuery);
    }

    public <E, R> StoredQuery<E, R> decorate(StoredQuery<E, R> storedQuery) {
        RuntimePersistentEntity runtimePersistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        return new DefaultBindableParametersStoredQuery(storedQuery, runtimePersistentEntity);
    }

    protected ApplicationContext getApplicationContext() {
        return this.runtimeEntityRegistry.getApplicationContext();
    }

    protected ConversionService<?> getConversionService() {
        return this.dataConversionService;
    }

    @NonNull
    protected abstract <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> var1);

    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        AnnotationMetadata annotationMetadata = storedQuery.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(EntityGraph.class)) {
            String hint = annotationMetadata.stringValue(EntityGraph.class, "hint").orElse(ENTITY_GRAPH_FETCH);
            String graphName = annotationMetadata.stringValue(EntityGraph.class).orElse(null);
            Object[] paths = annotationMetadata.stringValues(EntityGraph.class, "attributePaths");
            if (graphName != null) {
                return Collections.singletonMap(hint, graphName);
            }
            if (ArrayUtils.isNotEmpty((Object[])paths)) {
                return Collections.singletonMap(hint, paths);
            }
        }
        return Collections.emptyMap();
    }

    protected abstract void setParameter(Q var1, String var2, Object var3);

    protected abstract void setParameter(Q var1, String var2, Object var3, Argument var4);

    protected abstract void setParameterList(Q var1, String var2, Collection<Object> var3);

    protected abstract void setParameterList(Q var1, String var2, Collection<Object> var3, Argument var4);

    protected abstract void setHint(Q var1, String var2, Object var3);

    protected abstract void setMaxResults(Q var1, int var2);

    protected abstract void setOffset(Q var1, int var2);

    protected abstract <T> javax.persistence.EntityGraph<T> getEntityGraph(S var1, Class<T> var2, String var3);

    protected abstract <T> javax.persistence.EntityGraph<T> createEntityGraph(S var1, Class<T> var2);

    protected abstract Q createQuery(S var1, String var2, @Nullable Class<?> var3);

    protected abstract Q createNativeQuery(S var1, String var2, Class<?> var3);

    protected abstract Q createQuery(S var1, CriteriaQuery<?> var2);

    protected <R> void collectFindOne(S session, PreparedQuery<?, R> preparedQuery, ResultCollector<R> collector) {
        String query = preparedQuery.getQuery();
        this.collectResults(session, query, preparedQuery, collector);
    }

    protected <R> void collectFindAll(S session, PreparedQuery<?, R> preparedQuery, ResultCollector<R> collector) {
        Sort sort;
        String queryStr = preparedQuery.getQuery();
        Pageable pageable = preparedQuery.getPageable();
        if (pageable != Pageable.UNPAGED && (sort = pageable.getSort()).isSorted()) {
            queryStr = queryStr + QUERY_BUILDER.buildOrderBy(queryStr, this.getEntity(preparedQuery.getRootEntity()), sort).getQuery();
        }
        this.collectResults(session, queryStr, preparedQuery, collector);
    }

    private <T, R> void collectResults(S session, String queryStr, PreparedQuery<T, R> preparedQuery, ResultCollector<R> resultCollector) {
        if (preparedQuery.isDtoProjection()) {
            Q q;
            if (preparedQuery.isNative()) {
                q = this.createNativeQuery(session, queryStr, Tuple.class);
            } else {
                if (queryStr.toLowerCase(Locale.ENGLISH).startsWith("select new ")) {
                    Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
                    Q query = this.createQuery(session, queryStr, wrapperType);
                    this.bindPreparedQuery(query, preparedQuery, session);
                    resultCollector.collect(query);
                    return;
                }
                q = this.createQuery(session, queryStr, Tuple.class);
            }
            this.bindPreparedQuery(q, preparedQuery, session);
            resultCollector.collectTuple(q, tuple -> {
                final Set properties = tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
                return new BeanIntrospectionMapper<Tuple, R>(){

                    public Object read(Tuple tuple1, String alias) {
                        if (!properties.contains(alias)) {
                            return null;
                        }
                        return tuple1.get(alias);
                    }

                    public ConversionService<?> getConversionService() {
                        return AbstractHibernateOperations.this.dataConversionService;
                    }
                }.map(tuple, preparedQuery.getResultType());
            });
        } else {
            Q q;
            Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
            if (preparedQuery.isNative()) {
                Class rootEntity = preparedQuery.getRootEntity();
                if (wrapperType != rootEntity) {
                    Q nativeQuery = this.createNativeQuery(session, queryStr, Tuple.class);
                    this.bindPreparedQuery(nativeQuery, preparedQuery, session);
                    resultCollector.collectTuple(nativeQuery, tuple -> {
                        Object o = tuple.get(0);
                        if (wrapperType.isInstance(o)) {
                            return o;
                        }
                        return this.dataConversionService.convertRequired(o, wrapperType);
                    });
                    return;
                }
                q = this.createNativeQuery(session, queryStr, wrapperType);
            } else {
                q = this.createQuery(session, queryStr, wrapperType);
            }
            this.bindPreparedQuery(q, preparedQuery, session);
            resultCollector.collect(q);
        }
    }

    protected <T, R> void bindParameters(final Q q, final @NonNull PreparedQuery<T, R> preparedQuery) {
        BindableParametersPreparedQuery<T, R> bindableParametersPreparedQuery = this.getBindableParametersPreparedQuery(preparedQuery);
        bindableParametersPreparedQuery.bindParameters(new BindableParametersStoredQuery.Binder(){

            public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
                return AbstractHibernateOperations.this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
            }

            public Object convert(Object value, RuntimePersistentProperty<?> property) {
                return value;
            }

            public Object convert(Class<?> converterClass, Object value, Argument<?> argument) {
                return value;
            }

            public void bindOne(QueryParameterBinding binding, Object value) {
                String parameterName = Objects.requireNonNull(binding.getName(), "Parameter name cannot be null!");
                if (preparedQuery.isNative()) {
                    int parameterIndex = binding.getParameterIndex();
                    Argument argument = preparedQuery.getArguments()[parameterIndex];
                    Class argumentType = argument.getType();
                    if (Collection.class.isAssignableFrom(argumentType)) {
                        AbstractHibernateOperations.this.setParameterList(q, parameterName, value == null ? Collections.emptyList() : (Collection)value, argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
                    } else if (Object[].class.isAssignableFrom(argumentType)) {
                        Collection<Object> coll = value == null ? Collections.emptyList() : (value instanceof Collection ? (Collection)value : Arrays.asList((Object[])value));
                        AbstractHibernateOperations.this.setParameterList(q, parameterName, coll);
                    } else {
                        AbstractHibernateOperations.this.setParameter(q, parameterName, value, argument);
                    }
                } else {
                    AbstractHibernateOperations.this.setParameter(q, parameterName, value);
                }
            }

            public void bindMany(QueryParameterBinding binding, Collection<Object> values) {
                this.bindOne(binding, values);
            }
        });
    }

    private <T, R> void bindPreparedQuery(Q q, @NonNull PreparedQuery<T, R> preparedQuery, S currentSession) {
        this.bindParameters(q, preparedQuery);
        this.bindPageable(q, preparedQuery.getPageable());
        this.bindQueryHints(q, (PagedQuery<T>)preparedQuery, currentSession);
    }

    private <T> void bindQueryHints(Q q, @NonNull PagedQuery<T> preparedQuery, @NonNull S session) {
        Map queryHints = preparedQuery.getQueryHints();
        if (CollectionUtils.isNotEmpty((Map)queryHints)) {
            for (Map.Entry entry : queryHints.entrySet()) {
                String hintName = (String)entry.getKey();
                Object value = entry.getValue();
                if (ENTITY_GRAPH_FETCH.equals(hintName) || ENTITY_GRAPH_LOAD.equals(hintName)) {
                    Object[] pathsDefinitions;
                    String graphName = preparedQuery.getAnnotationMetadata().stringValue(EntityGraph.class).orElse(null);
                    if (graphName != null) {
                        javax.persistence.EntityGraph<T> entityGraph = this.getEntityGraph(session, preparedQuery.getRootEntity(), graphName);
                        this.setHint(q, hintName, entityGraph);
                        continue;
                    }
                    if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])(pathsDefinitions = (String[])value))) continue;
                    RootGraph<T> entityGraph = this.createGraph((String[])pathsDefinitions, session, preparedQuery.getRootEntity());
                    this.setHint(q, hintName, entityGraph);
                    continue;
                }
                this.setHint(q, hintName, value);
            }
        }
    }

    private <T> RootGraph<T> createGraph(@NonNull String[] paths, @NonNull S session, @NonNull Class<T> rootEntity) {
        RootGraph rootGraph = (RootGraph)this.createEntityGraph(session, rootEntity);
        for (String path : paths) {
            if (path.trim().equals("")) continue;
            String[] parts = path.split("\\.");
            if (parts.length == 1) {
                AttributeNode attrNode = rootGraph.findAttributeNode(path);
                if (attrNode != null) continue;
                rootGraph.addAttributeNode(path);
                continue;
            }
            RootGraph graph = rootGraph;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                AttributeNode attrNode = graph.findAttributeNode(part);
                if (attrNode != null) {
                    SubGraph subGraph;
                    SubGraph subGraph2 = subGraph = attrNode.getSubGraphs().isEmpty() ? null : (SubGraph)attrNode.getSubGraphs().values().iterator().next();
                    if (subGraph == null && i < parts.length - 1) {
                        graph = graph.addSubGraph(part);
                        continue;
                    }
                    if (subGraph == null) continue;
                    graph = subGraph;
                    continue;
                }
                if (i == parts.length - 1) {
                    graph.addAttributeNode(part);
                    continue;
                }
                graph = graph.addSubGraph(part);
            }
        }
        return rootGraph;
    }

    protected final Object getParameterValue(String[] propertyPath, Object value) {
        for (String property : propertyPath) {
            Object finalValue = value;
            BeanProperty beanProperty = (BeanProperty)BeanIntrospection.getIntrospection(value.getClass()).getProperty(property).orElseThrow(() -> new IntrospectionException("Cannot find a property: '" + property + "' on bean: " + finalValue));
            if ((value = beanProperty.get(value)) != null) continue;
            return null;
        }
        return value;
    }

    protected final FlushModeType getFlushModeType(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(QueryHint.class).stream().filter(av -> FlushModeType.class.getName().equals(av.stringValue("name").orElse(null))).map(av -> av.enumValue("value", FlushModeType.class)).findFirst().orElse(Optional.empty()).orElse(null);
    }

    private void bindPageable(Q q, @NonNull Pageable pageable) {
        long offset;
        if (pageable == Pageable.UNPAGED) {
            return;
        }
        int max = pageable.getSize();
        if (max > 0) {
            this.setMaxResults(q, max);
        }
        if ((offset = pageable.getOffset()) > 0L) {
            this.setOffset(q, (int)offset);
        }
    }

    protected final <T> void collectPagedResults(CriteriaBuilder criteriaBuilder, S session, PagedQuery<T> pagedQuery, ResultCollector<T> resultCollector) {
        Pageable pageable = pagedQuery.getPageable();
        Class entity = pagedQuery.getRootEntity();
        CriteriaQuery query = criteriaBuilder.createQuery(pagedQuery.getRootEntity());
        Root root = query.from(entity);
        this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
        Q q = this.createQuery(session, query);
        this.bindPageable(q, pageable);
        this.bindQueryHints(q, pagedQuery, session);
        resultCollector.collect(q);
    }

    protected final <R> void collectCountOf(CriteriaBuilder criteriaBuilder, S session, Class<R> entity, @Nullable Pageable pageable, ResultCollector<Long> resultCollector) {
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(entity)));
        Q countQ = this.createQuery(session, countQuery);
        if (pageable != null) {
            this.bindPageable(countQ, pageable);
        }
        resultCollector.collect(countQ);
    }

    private <T> void bindCriteriaSort(CriteriaQuery<T> criteriaQuery, Root<?> root, CriteriaBuilder builder, @NonNull Sort sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        block3: for (Sort.Order order : sort.getOrderBy()) {
            Path path = root.get(order.getProperty());
            Path expression = order.isIgnoreCase() ? builder.lower((Expression)path) : path;
            switch (order.getDirection()) {
                case DESC: {
                    orders.add(builder.desc((Expression)expression));
                    continue block3;
                }
            }
            orders.add(builder.asc((Expression)expression));
        }
        criteriaQuery.orderBy(orders);
    }

    private <E, R> BindableParametersPreparedQuery<E, R> getBindableParametersPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        if (preparedQuery instanceof BindableParametersPreparedQuery) {
            return (BindableParametersPreparedQuery)preparedQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: BindableParametersPreparedQuery");
    }

    protected abstract class ResultCollector<R> {
        protected ResultCollector() {
        }

        protected abstract void collectTuple(Q var1, Function<Tuple, R> var2);

        protected abstract void collect(Q var1);
    }
}

