/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.credentials.Authentication;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class EKSAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(EKSAuthentication.class);
    private static final int MAX_EXPIRY_SECONDS = 900;
    private final AwsCredentialsProvider provider;
    private final String region;
    private final String clusterName;
    private final URI stsEndpoint;
    private final int expirySeconds;

    public EKSAuthentication(AwsCredentialsProvider provider, String region, String clusterName) {
        this(provider, region, clusterName, 900);
    }

    public EKSAuthentication(AwsCredentialsProvider provider, String region, String clusterName, int expirySeconds) {
        this.provider = provider;
        this.region = region;
        this.clusterName = clusterName;
        if (expirySeconds > 900) {
            expirySeconds = 900;
        }
        this.expirySeconds = expirySeconds;
        this.stsEndpoint = URI.create("https://sts." + this.region + ".amazonaws.com");
    }

    @Override
    public void provide(ApiClient client) {
        SdkHttpRequest httpRequest = this.generateStsRequest();
        String presignedUrl = this.requestToPresignedUrl(httpRequest);
        String encodedUrl = EKSAuthentication.presignedUrlToEncodedUrl(presignedUrl);
        String token = "k8s-aws-v1." + encodedUrl;
        client.setApiKeyPrefix("Bearer");
        client.setApiKey(token);
        log.info("Generated BEARER token for ApiClient, expiring at {}", (Object)Instant.now().plus((long)this.expirySeconds, ChronoUnit.SECONDS));
    }

    private static String presignedUrlToEncodedUrl(String presignedUrl) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(SdkHttpUtils.urlEncodeIgnoreSlashes((String)presignedUrl).getBytes(StandardCharsets.UTF_8));
    }

    private SdkHttpRequest generateStsRequest() {
        return (SdkHttpRequest)SdkHttpRequest.builder().uri(this.stsEndpoint).putRawQueryParameter("Version", "2011-06-15").putRawQueryParameter("Action", "GetCallerIdentity").method(SdkHttpMethod.GET).putHeader("x-k8s-aws-id", this.clusterName).build();
    }

    private String requestToPresignedUrl(SdkHttpRequest httpRequest) {
        AwsV4HttpSigner signer = AwsV4HttpSigner.create();
        SignedRequest signedRequest = signer.sign(r -> ((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)((SignRequest.Builder)r.identity((Identity)this.provider.resolveCredentials())).request(httpRequest)).putProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"sts")).putProperty(AwsV4HttpSigner.REGION_NAME, (Object)this.region)).putProperty(AwsV4HttpSigner.AUTH_LOCATION, (Object)AwsV4FamilyHttpSigner.AuthLocation.QUERY_STRING)).putProperty(AwsV4HttpSigner.EXPIRATION_DURATION, (Object)Duration.of(60L, ChronoUnit.SECONDS)));
        SdkHttpRequest request = signedRequest.request();
        return request.getUri().toString();
    }
}

