/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.common.KubernetesType;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1JSONSchemaProps;
import io.kubernetes.client.util.ModelMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Represent;
import org.yaml.snakeyaml.representer.Representer;

public class Yaml {
    static final Logger logger = LoggerFactory.getLogger(Yaml.class);

    public static Object load(String content) throws IOException {
        return Yaml.load(new StringReader(content));
    }

    public static Object load(File f) throws IOException {
        return Yaml.load(new FileReader(f));
    }

    public static Object load(Reader reader) throws IOException {
        Map data = (Map)Yaml.getSnakeYaml(null, new TypeDescription[0]).load(reader);
        return Yaml.modelMapper(data);
    }

    public static <T> T loadAs(String content, Class<T> clazz) {
        return (T)Yaml.getSnakeYaml(clazz, new TypeDescription[0]).loadAs((Reader)new StringReader(content), clazz);
    }

    public static <T> T loadAs(File f, Class<T> clazz) throws IOException {
        return (T)Yaml.getSnakeYaml(clazz, new TypeDescription[0]).loadAs((Reader)new FileReader(f), clazz);
    }

    public static <T> T loadAs(Reader reader, Class<T> clazz) {
        return (T)Yaml.getSnakeYaml(clazz, new TypeDescription[0]).loadAs(reader, clazz);
    }

    public static List<Object> loadAll(String content) throws IOException {
        return Yaml.loadAll(new StringReader(content));
    }

    public static List<Object> loadAll(File f) throws IOException {
        return Yaml.loadAll(new FileReader(f));
    }

    public static List<Object> loadAll(Reader reader) throws IOException {
        Iterable iterable = Yaml.getSnakeYaml(null, new TypeDescription[0]).loadAll(reader);
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object object : iterable) {
            if (object == null) continue;
            try {
                list.add(Yaml.modelMapper((Map)object));
            }
            catch (ClassCastException ex) {
                logger.error("Unexpected exception while casting: {}", (Throwable)ex);
            }
        }
        return list;
    }

    public static String dump(Object object) {
        return Yaml.getSnakeYaml(object.getClass(), new TypeDescription[0]).dump(object);
    }

    public static void dump(Object object, Writer writer) {
        Yaml.getSnakeYaml(object.getClass(), new TypeDescription[0]).dump(object, writer);
    }

    public static String dumpAll(Iterator<? extends KubernetesType> data) {
        return Yaml.getSnakeYaml(null, new TypeDescription[0]).dumpAll(data);
    }

    public static void dumpAll(Iterator<? extends KubernetesType> data, Writer output) {
        Yaml.getSnakeYaml(null, new TypeDescription[0]).dumpAll(data, output);
    }

    @Deprecated
    public static org.yaml.snakeyaml.Yaml getSnakeYaml() {
        return Yaml.getSnakeYaml(null, new TypeDescription[0]);
    }

    public static org.yaml.snakeyaml.Yaml getSnakeYaml(Class<?> type, TypeDescription ... typeDescriptions) {
        return Yaml.getSnakeYaml(type, null, null, typeDescriptions);
    }

    public static org.yaml.snakeyaml.Yaml getSnakeYaml(Class<?> type, DumperOptions dumperOptions, LoaderOptions loaderOptions, TypeDescription ... typeDescriptions) {
        if (loaderOptions == null) {
            loaderOptions = new LoaderOptions();
        }
        loaderOptions.setEnumCaseSensitive(false);
        Object constructor = new SafeConstructor(loaderOptions);
        CustomRepresenter representer = new CustomRepresenter();
        if (type != null) {
            constructor = new CustomConstructor(type, loaderOptions);
        }
        Yaml.registerBuiltinGsonCompatibles((BaseConstructor)constructor, representer);
        for (TypeDescription desc : typeDescriptions) {
            Yaml.registerCustomTypeDescriptions((BaseConstructor)constructor, representer, desc);
        }
        if (dumperOptions == null) {
            dumperOptions = new DumperOptions();
            dumperOptions.setDefaultFlowStyle(representer.getDefaultFlowStyle());
            dumperOptions.setDefaultScalarStyle(representer.getDefaultScalarStyle());
            dumperOptions.setAllowReadOnlyProperties(representer.getPropertyUtils().isAllowReadOnlyProperties());
            dumperOptions.setTimeZone(representer.getTimeZone());
        }
        return new org.yaml.snakeyaml.Yaml((BaseConstructor)constructor, (Representer)representer, dumperOptions, loaderOptions);
    }

    public static TypeDescription newGsonCompatibleTypeDescription(Class modelClass, String ... gsonTaggedFields) {
        TypeDescription desc = new TypeDescription(modelClass);
        ArrayList<String> excluding = new ArrayList<String>();
        for (String targetGsonAnnotation : gsonTaggedFields) {
            Field field = Arrays.stream(modelClass.getDeclaredFields()).filter(f -> f.getAnnotation(SerializedName.class) != null).filter(f -> targetGsonAnnotation.equals(f.getAnnotation(SerializedName.class).value())).findAny().orElseThrow(() -> new IllegalArgumentException("Api model class " + modelClass.getSimpleName() + " doesn't have field with Gson @SerializedName with value " + targetGsonAnnotation));
            Method getterMethod = Yaml.tryFindGetterMethod(modelClass, field).orElseThrow(() -> new IllegalArgumentException("Cannot find getter method for " + targetGsonAnnotation + " on api model class " + modelClass.getSimpleName()));
            Method setterMethod = Yaml.tryFindSetterMethod(modelClass, field).orElseThrow(() -> new IllegalArgumentException("Cannot find setter method for " + targetGsonAnnotation + " on api model class " + modelClass.getSimpleName()));
            desc.substituteProperty(targetGsonAnnotation, field.getType(), getterMethod.getName(), setterMethod.getName(), new Class[0]);
            excluding.add(field.getName());
        }
        desc.setExcludes(excluding.toArray(new String[0]));
        return desc;
    }

    private static void registerBuiltinGsonCompatibles(BaseConstructor constructor, Representer representer) {
        String[] crdOpenApiExtensions = new String[]{"x-kubernetes-embedded-resource", "x-kubernetes-int-or-string", "x-kubernetes-list-map-keys", "x-kubernetes-list-type", "x-kubernetes-map-type", "x-kubernetes-preserve-unknown-fields"};
        Yaml.registerCustomTypeDescriptions(constructor, representer, Yaml.newGsonCompatibleTypeDescription(V1JSONSchemaProps.class, crdOpenApiExtensions));
    }

    private static void registerCustomTypeDescriptions(BaseConstructor constructor, Representer representer, TypeDescription ... addtionalTypeDescriptions) {
        Arrays.stream(addtionalTypeDescriptions).forEach(desc -> {
            constructor.addTypeDescription(desc);
            representer.addTypeDescription(desc);
        });
    }

    private static Optional<Method> tryFindGetterMethod(Class modelClass, Field targetField) {
        return Arrays.stream(modelClass.getDeclaredMethods()).filter(f -> f.getName().startsWith("get")).filter(f -> f.getName().equalsIgnoreCase("get" + targetField.getName())).findAny();
    }

    private static Optional<Method> tryFindSetterMethod(Class modelClass, Field targetField) {
        return Arrays.stream(modelClass.getDeclaredMethods()).filter(f -> f.getName().startsWith("set")).filter(f -> f.getName().equalsIgnoreCase("set" + targetField.getName())).findAny();
    }

    private static Object modelMapper(Map<String, Object> data) throws IOException {
        String kind = (String)data.get("kind");
        if (kind == null) {
            throw new IOException("Missing kind in YAML file!");
        }
        String apiVersion = (String)data.get("apiVersion");
        if (apiVersion == null) {
            throw new IOException("Missing apiVersion in YAML file!");
        }
        Class<?> clazz = ModelMapper.getApiTypeClass(apiVersion, kind);
        if (clazz == null) {
            throw new IOException("Unknown apiVersionKind " + apiVersion + "/" + kind + " is it registered?");
        }
        return Yaml.loadAs(new StringReader(Yaml.getSnakeYaml(clazz, new TypeDescription[0]).dump(data)), clazz);
    }

    @Deprecated
    public static void addModelMap(String apiGroupVersion, String kind, Class<?> clazz) {
        ModelMapper.addModelMap(apiGroupVersion, kind, clazz);
    }

    public static class CustomRepresenter
    extends Representer {
        public CustomRepresenter() {
            super(new DumperOptions());
            this.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            this.representers.put(IntOrString.class, new RepresentIntOrString());
            this.representers.put(byte[].class, new RepresentByteArray());
            this.representers.put(Quantity.class, new RepresentQuantity());
            this.representers.put(OffsetDateTime.class, new RepresentDateTime());
        }

        private int getPropertyPosition(String property) {
            switch (property) {
                case "apiVersion": {
                    return 0;
                }
                case "kind": {
                    return 1;
                }
                case "metadata": {
                    return 2;
                }
                case "spec": {
                    return 3;
                }
                case "type": {
                    return 4;
                }
            }
            return Integer.MAX_VALUE;
        }

        protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
            MappingNode node = super.representJavaBean(properties, javaBean);
            node.setTag(Tag.MAP);
            Collections.sort(node.getValue(), new Comparator<NodeTuple>(){

                @Override
                public int compare(NodeTuple a, NodeTuple b) {
                    String nameA = ((ScalarNode)a.getKeyNode()).getValue();
                    String nameB = ((ScalarNode)b.getKeyNode()).getValue();
                    int intCompare = Integer.compare(this.getPropertyPosition(nameA), this.getPropertyPosition(nameB));
                    if (intCompare != 0) {
                        return intCompare;
                    }
                    return nameA.compareTo(nameB);
                }
            });
            return node;
        }

        protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
            if (propertyValue == null) {
                return null;
            }
            return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
        }

        private class RepresentIntOrString
        implements Represent {
            private RepresentIntOrString() {
            }

            public Node representData(Object data) {
                IntOrString intOrString = (IntOrString)data;
                if (intOrString.isInteger()) {
                    return CustomRepresenter.this.representData(intOrString.getIntValue());
                }
                return CustomRepresenter.this.representData(intOrString.getStrValue());
            }
        }

        private class RepresentByteArray
        implements Represent {
            private RepresentByteArray() {
            }

            public Node representData(Object data) {
                String value = ByteString.of((byte[])((byte[])data)).base64();
                return CustomRepresenter.this.representScalar(Tag.STR, value);
            }
        }

        private class RepresentQuantity
        implements Represent {
            private RepresentQuantity() {
            }

            public Node representData(Object data) {
                Quantity quantity = (Quantity)data;
                return CustomRepresenter.this.representScalar(Tag.STR, quantity.toSuffixedString());
            }
        }

        private class RepresentDateTime
        implements Represent {
            private RepresentDateTime() {
            }

            public Node representData(Object data) {
                return CustomRepresenter.this.representData(data.toString());
            }
        }
    }

    public static class CustomConstructor
    extends Constructor {
        public CustomConstructor(Class<?> type, LoaderOptions loaderConfig) {
            super(type, loaderConfig);
        }

        protected Object constructObject(Node node) {
            if (node.getType() == IntOrString.class) {
                return this.constructIntOrString((ScalarNode)node);
            }
            if (node.getType() == byte[].class) {
                return this.constructByteArray((ScalarNode)node);
            }
            if (node.getType() == OffsetDateTime.class) {
                return this.constructDateTime((ScalarNode)node);
            }
            return super.constructObject(node);
        }

        private IntOrString constructIntOrString(ScalarNode node) {
            try {
                return new IntOrString(Integer.parseInt(node.getValue()));
            }
            catch (NumberFormatException err) {
                return new IntOrString(node.getValue());
            }
        }

        private byte[] constructByteArray(ScalarNode node) {
            return ByteString.decodeBase64((String)node.getValue()).toByteArray();
        }

        private Object constructDateTime(ScalarNode node) {
            if (node.getValue() == null || "null".equalsIgnoreCase(node.getValue())) {
                return null;
            }
            return OffsetDateTime.parse(node.getValue());
        }
    }
}

