/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.WebSocketStreamHandler;
import io.kubernetes.client.util.WebSockets;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Attach {
    private ApiClient apiClient;

    public Attach() {
        this(Configuration.getDefaultApiClient());
    }

    public Attach(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ConnectionBuilder newConnectionBuilder(String namespace, String name) {
        return new ConnectionBuilder(namespace, name);
    }

    public AttachResult attach(String namespace, String name, boolean stdin) throws ApiException, IOException {
        return this.attach(namespace, name, null, stdin, false);
    }

    public AttachResult attach(V1Pod pod, boolean stdin) throws ApiException, IOException {
        return this.attach(pod, stdin, false);
    }

    public AttachResult attach(V1Pod pod, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.attach(pod, null, stdin, tty);
    }

    public AttachResult attach(V1Pod pod, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.attach(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), container, stdin, tty);
    }

    public AttachResult attach(String namespace, String name, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.newConnectionBuilder(namespace, name).setContainer(container).setStdin(stdin).setTty(tty).connect();
    }

    public final class ConnectionBuilder {
        private final String namespace;
        private final String name;
        private String container;
        private boolean stdin;
        private boolean stdout;
        private boolean stderr;
        private boolean tty;

        private ConnectionBuilder(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            this.stdin = true;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getContainer() {
            return this.container;
        }

        public ConnectionBuilder setContainer(String container) {
            this.container = container;
            return this;
        }

        public boolean getStdin() {
            return this.stdin;
        }

        public ConnectionBuilder setStdin(boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        public boolean getStdout() {
            return this.stdout;
        }

        public ConnectionBuilder setStdout(boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        public boolean getStderr() {
            return this.stderr;
        }

        public ConnectionBuilder setStderr(boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        public boolean getTty() {
            return this.tty;
        }

        public ConnectionBuilder setTty(boolean tty) {
            this.tty = tty;
            return this;
        }

        private String makePath() {
            return "/api/v1/namespaces/" + this.namespace + "/pods/" + this.name + "/attach?stdin=" + this.stdin + "&stdout=" + this.stdout + "&stderr=" + this.stderr + "&tty=" + this.tty + (this.container != null ? "&container=" + this.container : "");
        }

        public AttachResult connect() throws ApiException, IOException {
            WebSocketStreamHandler handler = new WebSocketStreamHandler();
            AttachResult result = new AttachResult(handler);
            WebSockets.stream(this.makePath(), "GET", Attach.this.apiClient, handler);
            return result;
        }
    }

    public static class AttachResult
    implements Closeable {
        private WebSocketStreamHandler handler;

        public AttachResult(WebSocketStreamHandler handler) throws IOException {
            this.handler = handler;
        }

        public OutputStream getStandardInputStream() {
            return this.handler.getOutputStream(0);
        }

        public InputStream getStandardOutputStream() throws IOException {
            return this.handler.getInputStream(1);
        }

        public InputStream getErrorStream() {
            return this.handler.getInputStream(2);
        }

        public InputStream getConnectionErrorStream() {
            return this.handler.getInputStream(3);
        }

        public OutputStream getResizeStream() {
            return this.handler.getOutputStream(4);
        }

        @Override
        public void close() {
            this.handler.close();
        }
    }
}

