/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.util.ConfigPersister;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class FilePersister
implements ConfigPersister {
    File configFile;

    public FilePersister(String filename) {
        this(new File(filename));
    }

    public FilePersister(File file) {
        this.configFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(ArrayList<Object> contexts, ArrayList<Object> clusters, ArrayList<Object> users, Object preferences, String currentContext) throws IOException {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("apiVersion", "v1");
        config.put("kind", "Config");
        config.put("current-context", currentContext);
        config.put("preferences", preferences);
        config.put("clusters", clusters);
        config.put("contexts", contexts);
        config.put("users", users);
        File file = this.configFile;
        synchronized (file) {
            try (FileWriter fw = new FileWriter(this.configFile);){
                Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
                yaml.dump(config, (Writer)fw);
                fw.flush();
            }
        }
    }
}

