/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cert.manager.models.V1beta1OrderStatusChallenges;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ACMEAuthorization contains data returned from the ACME server on an authorization that must be completed in order validate a DNS name on an ACME Order resource.")
public class V1beta1OrderStatusAuthorizations {
    public static final String SERIALIZED_NAME_CHALLENGES = "challenges";
    @SerializedName(value="challenges")
    private List<V1beta1OrderStatusChallenges> challenges = null;
    public static final String SERIALIZED_NAME_IDENTIFIER = "identifier";
    @SerializedName(value="identifier")
    private String identifier;
    public static final String SERIALIZED_NAME_INITIAL_STATE = "initialState";
    @SerializedName(value="initialState")
    private InitialStateEnum initialState;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_WILDCARD = "wildcard";
    @SerializedName(value="wildcard")
    private Boolean wildcard;

    public V1beta1OrderStatusAuthorizations challenges(List<V1beta1OrderStatusChallenges> challenges) {
        this.challenges = challenges;
        return this;
    }

    public V1beta1OrderStatusAuthorizations addChallengesItem(V1beta1OrderStatusChallenges challengesItem) {
        if (this.challenges == null) {
            this.challenges = new ArrayList<V1beta1OrderStatusChallenges>();
        }
        this.challenges.add(challengesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Challenges specifies the challenge types offered by the ACME server. One of these challenge types will be selected when validating the DNS name and an appropriate Challenge resource will be created to perform the ACME challenge process.")
    public List<V1beta1OrderStatusChallenges> getChallenges() {
        return this.challenges;
    }

    public void setChallenges(List<V1beta1OrderStatusChallenges> challenges) {
        this.challenges = challenges;
    }

    public V1beta1OrderStatusAuthorizations identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier is the DNS name to be validated as part of this authorization")
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public V1beta1OrderStatusAuthorizations initialState(InitialStateEnum initialState) {
        this.initialState = initialState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InitialState is the initial state of the ACME authorization when first fetched from the ACME server. If an Authorization is already 'valid', the Order controller will not create a Challenge resource for the authorization. This will occur when working with an ACME server that enables 'authz reuse' (such as Let's Encrypt's production endpoint). If not set and 'identifier' is set, the state is assumed to be pending and a Challenge will be created.")
    public InitialStateEnum getInitialState() {
        return this.initialState;
    }

    public void setInitialState(InitialStateEnum initialState) {
        this.initialState = initialState;
    }

    public V1beta1OrderStatusAuthorizations url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(required=true, value="URL is the URL of the Authorization that must be completed")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public V1beta1OrderStatusAuthorizations wildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Wildcard will be true if this authorization is for a wildcard DNS name. If this is true, the identifier will be the *non-wildcard* version of the DNS name. For example, if '*.example.com' is the DNS name being validated, this field will be 'true' and the 'identifier' field will be 'example.com'.")
    public Boolean getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1OrderStatusAuthorizations v1beta1OrderStatusAuthorizations = (V1beta1OrderStatusAuthorizations)o;
        return Objects.equals(this.challenges, v1beta1OrderStatusAuthorizations.challenges) && Objects.equals(this.identifier, v1beta1OrderStatusAuthorizations.identifier) && Objects.equals((Object)this.initialState, (Object)v1beta1OrderStatusAuthorizations.initialState) && Objects.equals(this.url, v1beta1OrderStatusAuthorizations.url) && Objects.equals(this.wildcard, v1beta1OrderStatusAuthorizations.wildcard);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.challenges, this.identifier, this.initialState, this.url, this.wildcard});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1OrderStatusAuthorizations {\n");
        sb.append("    challenges: ").append(this.toIndentedString(this.challenges)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    initialState: ").append(this.toIndentedString((Object)this.initialState)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    wildcard: ").append(this.toIndentedString(this.wildcard)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InitialStateEnum {
        VALID("valid"),
        READY("ready"),
        PENDING("pending"),
        PROCESSING("processing"),
        INVALID("invalid"),
        EXPIRED("expired"),
        ERRORED("errored");

        private String value;

        private InitialStateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InitialStateEnum fromValue(String value) {
            for (InitialStateEnum b : InitialStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<InitialStateEnum> {
            public void write(JsonWriter jsonWriter, InitialStateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InitialStateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InitialStateEnum.fromValue(value);
            }
        }
    }
}

