/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IssuerRef references a properly configured ACME-type Issuer which should be used to create this Order. If the Issuer does not exist, processing will be retried. If the Issuer is not an 'ACME' Issuer, an error will be returned and the Order will be marked as failed.")
public class V1beta1OrderSpecIssuerRef {
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V1beta1OrderSpecIssuerRef group(String group) {
        this.group = group;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group of the resource being referred to.")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public V1beta1OrderSpecIssuerRef kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind of the resource being referred to.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1OrderSpecIssuerRef name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the resource being referred to.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1OrderSpecIssuerRef v1beta1OrderSpecIssuerRef = (V1beta1OrderSpecIssuerRef)o;
        return Objects.equals(this.group, v1beta1OrderSpecIssuerRef.group) && Objects.equals(this.kind, v1beta1OrderSpecIssuerRef.kind) && Objects.equals(this.name, v1beta1OrderSpecIssuerRef.name);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.kind, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1OrderSpecIssuerRef {\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

