/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1beta1CertificateStatusConditions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@ApiModel(description="Status of the Certificate. This is set and managed automatically.")
public class V1beta1CertificateStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    private List<V1beta1CertificateStatusConditions> conditions = null;
    public static final String SERIALIZED_NAME_LAST_FAILURE_TIME = "lastFailureTime";
    @SerializedName(value="lastFailureTime")
    private DateTime lastFailureTime;
    public static final String SERIALIZED_NAME_NEXT_PRIVATE_KEY_SECRET_NAME = "nextPrivateKeySecretName";
    @SerializedName(value="nextPrivateKeySecretName")
    private String nextPrivateKeySecretName;
    public static final String SERIALIZED_NAME_NOT_AFTER = "notAfter";
    @SerializedName(value="notAfter")
    private DateTime notAfter;
    public static final String SERIALIZED_NAME_NOT_BEFORE = "notBefore";
    @SerializedName(value="notBefore")
    private DateTime notBefore;
    public static final String SERIALIZED_NAME_RENEWAL_TIME = "renewalTime";
    @SerializedName(value="renewalTime")
    private DateTime renewalTime;
    public static final String SERIALIZED_NAME_REVISION = "revision";
    @SerializedName(value="revision")
    private Integer revision;

    public V1beta1CertificateStatus conditions(List<V1beta1CertificateStatusConditions> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta1CertificateStatus addConditionsItem(V1beta1CertificateStatusConditions conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1CertificateStatusConditions>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of status conditions to indicate the status of certificates. Known condition types are `Ready` and `Issuing`.")
    public List<V1beta1CertificateStatusConditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta1CertificateStatusConditions> conditions) {
        this.conditions = conditions;
    }

    public V1beta1CertificateStatus lastFailureTime(DateTime lastFailureTime) {
        this.lastFailureTime = lastFailureTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LastFailureTime is the time as recorded by the Certificate controller of the most recent failure to complete a CertificateRequest for this Certificate resource. If set, cert-manager will not re-request another Certificate until 1 hour has elapsed from this time.")
    public DateTime getLastFailureTime() {
        return this.lastFailureTime;
    }

    public void setLastFailureTime(DateTime lastFailureTime) {
        this.lastFailureTime = lastFailureTime;
    }

    public V1beta1CertificateStatus nextPrivateKeySecretName(String nextPrivateKeySecretName) {
        this.nextPrivateKeySecretName = nextPrivateKeySecretName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the Secret resource containing the private key to be used for the next certificate iteration. The keymanager controller will automatically set this field if the `Issuing` condition is set to `True`. It will automatically unset this field when the Issuing condition is not set or False.")
    public String getNextPrivateKeySecretName() {
        return this.nextPrivateKeySecretName;
    }

    public void setNextPrivateKeySecretName(String nextPrivateKeySecretName) {
        this.nextPrivateKeySecretName = nextPrivateKeySecretName;
    }

    public V1beta1CertificateStatus notAfter(DateTime notAfter) {
        this.notAfter = notAfter;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The expiration time of the certificate stored in the secret named by this resource in `spec.secretName`.")
    public DateTime getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(DateTime notAfter) {
        this.notAfter = notAfter;
    }

    public V1beta1CertificateStatus notBefore(DateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the certificate stored in the secret named by this resource in spec.secretName is valid.")
    public DateTime getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(DateTime notBefore) {
        this.notBefore = notBefore;
    }

    public V1beta1CertificateStatus renewalTime(DateTime renewalTime) {
        this.renewalTime = renewalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RenewalTime is the time at which the certificate will be next renewed. If not set, no upcoming renewal is scheduled.")
    public DateTime getRenewalTime() {
        return this.renewalTime;
    }

    public void setRenewalTime(DateTime renewalTime) {
        this.renewalTime = renewalTime;
    }

    public V1beta1CertificateStatus revision(Integer revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The current 'revision' of the certificate as issued.   When a CertificateRequest resource is created, it will have the `cert-manager.io/certificate-revision` set to one greater than the current value of this field.   Upon issuance, this field will be set to the value of the annotation on the CertificateRequest resource used to issue the certificate.   Persisting the value on the CertificateRequest resource allows the certificates controller to know whether a request is part of an old issuance or if it is part of the ongoing revision's issuance by checking if the revision value in the annotation is greater than this field.")
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateStatus v1beta1CertificateStatus = (V1beta1CertificateStatus)o;
        return Objects.equals(this.conditions, v1beta1CertificateStatus.conditions) && Objects.equals(this.lastFailureTime, v1beta1CertificateStatus.lastFailureTime) && Objects.equals(this.nextPrivateKeySecretName, v1beta1CertificateStatus.nextPrivateKeySecretName) && Objects.equals(this.notAfter, v1beta1CertificateStatus.notAfter) && Objects.equals(this.notBefore, v1beta1CertificateStatus.notBefore) && Objects.equals(this.renewalTime, v1beta1CertificateStatus.renewalTime) && Objects.equals(this.revision, v1beta1CertificateStatus.revision);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.lastFailureTime, this.nextPrivateKeySecretName, this.notAfter, this.notBefore, this.renewalTime, this.revision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    lastFailureTime: ").append(this.toIndentedString(this.lastFailureTime)).append("\n");
        sb.append("    nextPrivateKeySecretName: ").append(this.toIndentedString(this.nextPrivateKeySecretName)).append("\n");
        sb.append("    notAfter: ").append(this.toIndentedString(this.notAfter)).append("\n");
        sb.append("    notBefore: ").append(this.toIndentedString(this.notBefore)).append("\n");
        sb.append("    renewalTime: ").append(this.toIndentedString(this.renewalTime)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

