/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Full X509 name specification (https://golang.org/pkg/crypto/x509/pkix/#Name).")
public class V1beta1CertificateSpecSubject {
    public static final String SERIALIZED_NAME_COUNTRIES = "countries";
    @SerializedName(value="countries")
    private List<String> countries = null;
    public static final String SERIALIZED_NAME_LOCALITIES = "localities";
    @SerializedName(value="localities")
    private List<String> localities = null;
    public static final String SERIALIZED_NAME_ORGANIZATIONAL_UNITS = "organizationalUnits";
    @SerializedName(value="organizationalUnits")
    private List<String> organizationalUnits = null;
    public static final String SERIALIZED_NAME_ORGANIZATIONS = "organizations";
    @SerializedName(value="organizations")
    private List<String> organizations = null;
    public static final String SERIALIZED_NAME_POSTAL_CODES = "postalCodes";
    @SerializedName(value="postalCodes")
    private List<String> postalCodes = null;
    public static final String SERIALIZED_NAME_PROVINCES = "provinces";
    @SerializedName(value="provinces")
    private List<String> provinces = null;
    public static final String SERIALIZED_NAME_SERIAL_NUMBER = "serialNumber";
    @SerializedName(value="serialNumber")
    private String serialNumber;
    public static final String SERIALIZED_NAME_STREET_ADDRESSES = "streetAddresses";
    @SerializedName(value="streetAddresses")
    private List<String> streetAddresses = null;

    public V1beta1CertificateSpecSubject countries(List<String> countries) {
        this.countries = countries;
        return this;
    }

    public V1beta1CertificateSpecSubject addCountriesItem(String countriesItem) {
        if (this.countries == null) {
            this.countries = new ArrayList<String>();
        }
        this.countries.add(countriesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Countries to be used on the Certificate.")
    public List<String> getCountries() {
        return this.countries;
    }

    public void setCountries(List<String> countries) {
        this.countries = countries;
    }

    public V1beta1CertificateSpecSubject localities(List<String> localities) {
        this.localities = localities;
        return this;
    }

    public V1beta1CertificateSpecSubject addLocalitiesItem(String localitiesItem) {
        if (this.localities == null) {
            this.localities = new ArrayList<String>();
        }
        this.localities.add(localitiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Cities to be used on the Certificate.")
    public List<String> getLocalities() {
        return this.localities;
    }

    public void setLocalities(List<String> localities) {
        this.localities = localities;
    }

    public V1beta1CertificateSpecSubject organizationalUnits(List<String> organizationalUnits) {
        this.organizationalUnits = organizationalUnits;
        return this;
    }

    public V1beta1CertificateSpecSubject addOrganizationalUnitsItem(String organizationalUnitsItem) {
        if (this.organizationalUnits == null) {
            this.organizationalUnits = new ArrayList<String>();
        }
        this.organizationalUnits.add(organizationalUnitsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Organizational Units to be used on the Certificate.")
    public List<String> getOrganizationalUnits() {
        return this.organizationalUnits;
    }

    public void setOrganizationalUnits(List<String> organizationalUnits) {
        this.organizationalUnits = organizationalUnits;
    }

    public V1beta1CertificateSpecSubject organizations(List<String> organizations) {
        this.organizations = organizations;
        return this;
    }

    public V1beta1CertificateSpecSubject addOrganizationsItem(String organizationsItem) {
        if (this.organizations == null) {
            this.organizations = new ArrayList<String>();
        }
        this.organizations.add(organizationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Organizations to be used on the Certificate.")
    public List<String> getOrganizations() {
        return this.organizations;
    }

    public void setOrganizations(List<String> organizations) {
        this.organizations = organizations;
    }

    public V1beta1CertificateSpecSubject postalCodes(List<String> postalCodes) {
        this.postalCodes = postalCodes;
        return this;
    }

    public V1beta1CertificateSpecSubject addPostalCodesItem(String postalCodesItem) {
        if (this.postalCodes == null) {
            this.postalCodes = new ArrayList<String>();
        }
        this.postalCodes.add(postalCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Postal codes to be used on the Certificate.")
    public List<String> getPostalCodes() {
        return this.postalCodes;
    }

    public void setPostalCodes(List<String> postalCodes) {
        this.postalCodes = postalCodes;
    }

    public V1beta1CertificateSpecSubject provinces(List<String> provinces) {
        this.provinces = provinces;
        return this;
    }

    public V1beta1CertificateSpecSubject addProvincesItem(String provincesItem) {
        if (this.provinces == null) {
            this.provinces = new ArrayList<String>();
        }
        this.provinces.add(provincesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="State/Provinces to be used on the Certificate.")
    public List<String> getProvinces() {
        return this.provinces;
    }

    public void setProvinces(List<String> provinces) {
        this.provinces = provinces;
    }

    public V1beta1CertificateSpecSubject serialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Serial number to be used on the Certificate.")
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public V1beta1CertificateSpecSubject streetAddresses(List<String> streetAddresses) {
        this.streetAddresses = streetAddresses;
        return this;
    }

    public V1beta1CertificateSpecSubject addStreetAddressesItem(String streetAddressesItem) {
        if (this.streetAddresses == null) {
            this.streetAddresses = new ArrayList<String>();
        }
        this.streetAddresses.add(streetAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Street addresses to be used on the Certificate.")
    public List<String> getStreetAddresses() {
        return this.streetAddresses;
    }

    public void setStreetAddresses(List<String> streetAddresses) {
        this.streetAddresses = streetAddresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateSpecSubject v1beta1CertificateSpecSubject = (V1beta1CertificateSpecSubject)o;
        return Objects.equals(this.countries, v1beta1CertificateSpecSubject.countries) && Objects.equals(this.localities, v1beta1CertificateSpecSubject.localities) && Objects.equals(this.organizationalUnits, v1beta1CertificateSpecSubject.organizationalUnits) && Objects.equals(this.organizations, v1beta1CertificateSpecSubject.organizations) && Objects.equals(this.postalCodes, v1beta1CertificateSpecSubject.postalCodes) && Objects.equals(this.provinces, v1beta1CertificateSpecSubject.provinces) && Objects.equals(this.serialNumber, v1beta1CertificateSpecSubject.serialNumber) && Objects.equals(this.streetAddresses, v1beta1CertificateSpecSubject.streetAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.countries, this.localities, this.organizationalUnits, this.organizations, this.postalCodes, this.provinces, this.serialNumber, this.streetAddresses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateSpecSubject {\n");
        sb.append("    countries: ").append(this.toIndentedString(this.countries)).append("\n");
        sb.append("    localities: ").append(this.toIndentedString(this.localities)).append("\n");
        sb.append("    organizationalUnits: ").append(this.toIndentedString(this.organizationalUnits)).append("\n");
        sb.append("    organizations: ").append(this.toIndentedString(this.organizations)).append("\n");
        sb.append("    postalCodes: ").append(this.toIndentedString(this.postalCodes)).append("\n");
        sb.append("    provinces: ").append(this.toIndentedString(this.provinces)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("    streetAddresses: ").append(this.toIndentedString(this.streetAddresses)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

