/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.cert.manager.models.V1beta1CertificateSpecIssuerRef;
import io.cert.manager.models.V1beta1CertificateSpecKeystores;
import io.cert.manager.models.V1beta1CertificateSpecPrivateKey;
import io.cert.manager.models.V1beta1CertificateSpecSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Desired state of the Certificate resource.")
public class V1beta1CertificateSpec {
    public static final String SERIALIZED_NAME_COMMON_NAME = "commonName";
    @SerializedName(value="commonName")
    private String commonName;
    public static final String SERIALIZED_NAME_DNS_NAMES = "dnsNames";
    @SerializedName(value="dnsNames")
    private List<String> dnsNames = null;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private String duration;
    public static final String SERIALIZED_NAME_EMAIL_S_A_NS = "emailSANs";
    @SerializedName(value="emailSANs")
    private List<String> emailSANs = null;
    public static final String SERIALIZED_NAME_IP_ADDRESSES = "ipAddresses";
    @SerializedName(value="ipAddresses")
    private List<String> ipAddresses = null;
    public static final String SERIALIZED_NAME_IS_C_A = "isCA";
    @SerializedName(value="isCA")
    private Boolean isCA;
    public static final String SERIALIZED_NAME_ISSUER_REF = "issuerRef";
    @SerializedName(value="issuerRef")
    private V1beta1CertificateSpecIssuerRef issuerRef;
    public static final String SERIALIZED_NAME_KEYSTORES = "keystores";
    @SerializedName(value="keystores")
    private V1beta1CertificateSpecKeystores keystores;
    public static final String SERIALIZED_NAME_PRIVATE_KEY = "privateKey";
    @SerializedName(value="privateKey")
    private V1beta1CertificateSpecPrivateKey privateKey;
    public static final String SERIALIZED_NAME_RENEW_BEFORE = "renewBefore";
    @SerializedName(value="renewBefore")
    private String renewBefore;
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    private String secretName;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private V1beta1CertificateSpecSubject subject;
    public static final String SERIALIZED_NAME_URI_S_A_NS = "uriSANs";
    @SerializedName(value="uriSANs")
    private List<String> uriSANs = null;
    public static final String SERIALIZED_NAME_USAGES = "usages";
    @SerializedName(value="usages")
    private List<UsagesEnum> usages = null;

    public V1beta1CertificateSpec commonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CommonName is a common name to be used on the Certificate. The CommonName should have a length of 64 characters or fewer to avoid generating invalid CSRs. This value is ignored by TLS clients when any subject alt name is set. This is x509 behaviour: https://tools.ietf.org/html/rfc6125#section-6.4.4")
    public String getCommonName() {
        return this.commonName;
    }

    public void setCommonName(String commonName) {
        this.commonName = commonName;
    }

    public V1beta1CertificateSpec dnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
        return this;
    }

    public V1beta1CertificateSpec addDnsNamesItem(String dnsNamesItem) {
        if (this.dnsNames == null) {
            this.dnsNames = new ArrayList<String>();
        }
        this.dnsNames.add(dnsNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DNSNames is a list of DNS subjectAltNames to be set on the Certificate.")
    public List<String> getDnsNames() {
        return this.dnsNames;
    }

    public void setDnsNames(List<String> dnsNames) {
        this.dnsNames = dnsNames;
    }

    public V1beta1CertificateSpec duration(String duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The requested 'duration' (i.e. lifetime) of the Certificate. This option may be ignored/overridden by some issuer types. If overridden and `renewBefore` is greater than the actual certificate duration, the certificate will be automatically renewed 2/3rds of the way through the certificate's duration.")
    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public V1beta1CertificateSpec emailSANs(List<String> emailSANs) {
        this.emailSANs = emailSANs;
        return this;
    }

    public V1beta1CertificateSpec addEmailSANsItem(String emailSANsItem) {
        if (this.emailSANs == null) {
            this.emailSANs = new ArrayList<String>();
        }
        this.emailSANs.add(emailSANsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="EmailSANs is a list of email subjectAltNames to be set on the Certificate.")
    public List<String> getEmailSANs() {
        return this.emailSANs;
    }

    public void setEmailSANs(List<String> emailSANs) {
        this.emailSANs = emailSANs;
    }

    public V1beta1CertificateSpec ipAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public V1beta1CertificateSpec addIpAddressesItem(String ipAddressesItem) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(ipAddressesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IPAddresses is a list of IP address subjectAltNames to be set on the Certificate.")
    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public V1beta1CertificateSpec isCA(Boolean isCA) {
        this.isCA = isCA;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IsCA will mark this Certificate as valid for certificate signing. This will automatically add the `cert sign` usage to the list of `usages`.")
    public Boolean getIsCA() {
        return this.isCA;
    }

    public void setIsCA(Boolean isCA) {
        this.isCA = isCA;
    }

    public V1beta1CertificateSpec issuerRef(V1beta1CertificateSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1beta1CertificateSpecIssuerRef getIssuerRef() {
        return this.issuerRef;
    }

    public void setIssuerRef(V1beta1CertificateSpecIssuerRef issuerRef) {
        this.issuerRef = issuerRef;
    }

    public V1beta1CertificateSpec keystores(V1beta1CertificateSpecKeystores keystores) {
        this.keystores = keystores;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CertificateSpecKeystores getKeystores() {
        return this.keystores;
    }

    public void setKeystores(V1beta1CertificateSpecKeystores keystores) {
        this.keystores = keystores;
    }

    public V1beta1CertificateSpec privateKey(V1beta1CertificateSpecPrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CertificateSpecPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(V1beta1CertificateSpecPrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public V1beta1CertificateSpec renewBefore(String renewBefore) {
        this.renewBefore = renewBefore;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of time before the currently issued certificate's `notAfter` time that cert-manager will begin to attempt to renew the certificate. If this value is greater than the total duration of the certificate (i.e. notAfter - notBefore), it will be automatically renewed 2/3rds of the way through the certificate's duration.")
    public String getRenewBefore() {
        return this.renewBefore;
    }

    public void setRenewBefore(String renewBefore) {
        this.renewBefore = renewBefore;
    }

    public V1beta1CertificateSpec secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @ApiModelProperty(required=true, value="SecretName is the name of the secret resource that will be automatically created and managed by this Certificate resource. It will be populated with a private key and certificate, signed by the denoted issuer.")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public V1beta1CertificateSpec subject(V1beta1CertificateSpecSubject subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CertificateSpecSubject getSubject() {
        return this.subject;
    }

    public void setSubject(V1beta1CertificateSpecSubject subject) {
        this.subject = subject;
    }

    public V1beta1CertificateSpec uriSANs(List<String> uriSANs) {
        this.uriSANs = uriSANs;
        return this;
    }

    public V1beta1CertificateSpec addUriSANsItem(String uriSANsItem) {
        if (this.uriSANs == null) {
            this.uriSANs = new ArrayList<String>();
        }
        this.uriSANs.add(uriSANsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URISANs is a list of URI subjectAltNames to be set on the Certificate.")
    public List<String> getUriSANs() {
        return this.uriSANs;
    }

    public void setUriSANs(List<String> uriSANs) {
        this.uriSANs = uriSANs;
    }

    public V1beta1CertificateSpec usages(List<UsagesEnum> usages) {
        this.usages = usages;
        return this;
    }

    public V1beta1CertificateSpec addUsagesItem(UsagesEnum usagesItem) {
        if (this.usages == null) {
            this.usages = new ArrayList<UsagesEnum>();
        }
        this.usages.add(usagesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Usages is the set of x509 usages that are requested for the certificate. Defaults to `digital signature` and `key encipherment` if not specified.")
    public List<UsagesEnum> getUsages() {
        return this.usages;
    }

    public void setUsages(List<UsagesEnum> usages) {
        this.usages = usages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateSpec v1beta1CertificateSpec = (V1beta1CertificateSpec)o;
        return Objects.equals(this.commonName, v1beta1CertificateSpec.commonName) && Objects.equals(this.dnsNames, v1beta1CertificateSpec.dnsNames) && Objects.equals(this.duration, v1beta1CertificateSpec.duration) && Objects.equals(this.emailSANs, v1beta1CertificateSpec.emailSANs) && Objects.equals(this.ipAddresses, v1beta1CertificateSpec.ipAddresses) && Objects.equals(this.isCA, v1beta1CertificateSpec.isCA) && Objects.equals(this.issuerRef, v1beta1CertificateSpec.issuerRef) && Objects.equals(this.keystores, v1beta1CertificateSpec.keystores) && Objects.equals(this.privateKey, v1beta1CertificateSpec.privateKey) && Objects.equals(this.renewBefore, v1beta1CertificateSpec.renewBefore) && Objects.equals(this.secretName, v1beta1CertificateSpec.secretName) && Objects.equals(this.subject, v1beta1CertificateSpec.subject) && Objects.equals(this.uriSANs, v1beta1CertificateSpec.uriSANs) && Objects.equals(this.usages, v1beta1CertificateSpec.usages);
    }

    public int hashCode() {
        return Objects.hash(this.commonName, this.dnsNames, this.duration, this.emailSANs, this.ipAddresses, this.isCA, this.issuerRef, this.keystores, this.privateKey, this.renewBefore, this.secretName, this.subject, this.uriSANs, this.usages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateSpec {\n");
        sb.append("    commonName: ").append(this.toIndentedString(this.commonName)).append("\n");
        sb.append("    dnsNames: ").append(this.toIndentedString(this.dnsNames)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    emailSANs: ").append(this.toIndentedString(this.emailSANs)).append("\n");
        sb.append("    ipAddresses: ").append(this.toIndentedString(this.ipAddresses)).append("\n");
        sb.append("    isCA: ").append(this.toIndentedString(this.isCA)).append("\n");
        sb.append("    issuerRef: ").append(this.toIndentedString(this.issuerRef)).append("\n");
        sb.append("    keystores: ").append(this.toIndentedString(this.keystores)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    renewBefore: ").append(this.toIndentedString(this.renewBefore)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    uriSANs: ").append(this.toIndentedString(this.uriSANs)).append("\n");
        sb.append("    usages: ").append(this.toIndentedString(this.usages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum UsagesEnum {
        SIGNING("signing"),
        DIGITAL_SIGNATURE("digital signature"),
        CONTENT_COMMITMENT("content commitment"),
        KEY_ENCIPHERMENT("key encipherment"),
        KEY_AGREEMENT("key agreement"),
        DATA_ENCIPHERMENT("data encipherment"),
        CERT_SIGN("cert sign"),
        CRL_SIGN("crl sign"),
        ENCIPHER_ONLY("encipher only"),
        DECIPHER_ONLY("decipher only"),
        ANY("any"),
        SERVER_AUTH("server auth"),
        CLIENT_AUTH("client auth"),
        CODE_SIGNING("code signing"),
        EMAIL_PROTECTION("email protection"),
        S_MIME("s/mime"),
        IPSEC_END_SYSTEM("ipsec end system"),
        IPSEC_TUNNEL("ipsec tunnel"),
        IPSEC_USER("ipsec user"),
        TIMESTAMPING("timestamping"),
        OCSP_SIGNING("ocsp signing"),
        MICROSOFT_SGC("microsoft sgc"),
        NETSCAPE_SGC("netscape sgc");

        private String value;

        private UsagesEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static UsagesEnum fromValue(String value) {
            for (UsagesEnum b : UsagesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<UsagesEnum> {
            public void write(JsonWriter jsonWriter, UsagesEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public UsagesEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return UsagesEnum.fromValue(value);
            }
        }
    }
}

