/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.cert.manager.models.V1alpha2IssuerSpecVaultAuthAppRoleSecretRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="AppRole authenticates with Vault using the App Role auth mechanism, with the role and secret stored in a Kubernetes Secret resource.")
public class V1alpha2IssuerSpecVaultAuthAppRole {
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_ROLE_ID = "roleId";
    @SerializedName(value="roleId")
    private String roleId;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1alpha2IssuerSpecVaultAuthAppRoleSecretRef secretRef;

    public V1alpha2IssuerSpecVaultAuthAppRole path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path where the App Role authentication backend is mounted in Vault, e.g: \"approle\"")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1alpha2IssuerSpecVaultAuthAppRole roleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    @ApiModelProperty(required=true, value="RoleID configured in the App Role authentication backend when setting up the authentication backend in Vault.")
    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public V1alpha2IssuerSpecVaultAuthAppRole secretRef(V1alpha2IssuerSpecVaultAuthAppRoleSecretRef secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public V1alpha2IssuerSpecVaultAuthAppRoleSecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1alpha2IssuerSpecVaultAuthAppRoleSecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecVaultAuthAppRole v1alpha2IssuerSpecVaultAuthAppRole = (V1alpha2IssuerSpecVaultAuthAppRole)o;
        return Objects.equals(this.path, v1alpha2IssuerSpecVaultAuthAppRole.path) && Objects.equals(this.roleId, v1alpha2IssuerSpecVaultAuthAppRole.roleId) && Objects.equals(this.secretRef, v1alpha2IssuerSpecVaultAuthAppRole.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.roleId, this.secretRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecVaultAuthAppRole {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    roleId: ").append(this.toIndentedString(this.roleId)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

