/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SelfSigned configures this issuer to 'self sign' certificates using the private key used to create the CertificateRequest object.")
public class V1alpha2IssuerSpecSelfSigned {
    public static final String SERIALIZED_NAME_CRL_DISTRIBUTION_POINTS = "crlDistributionPoints";
    @SerializedName(value="crlDistributionPoints")
    private List<String> crlDistributionPoints = null;

    public V1alpha2IssuerSpecSelfSigned crlDistributionPoints(List<String> crlDistributionPoints) {
        this.crlDistributionPoints = crlDistributionPoints;
        return this;
    }

    public V1alpha2IssuerSpecSelfSigned addCrlDistributionPointsItem(String crlDistributionPointsItem) {
        if (this.crlDistributionPoints == null) {
            this.crlDistributionPoints = new ArrayList<String>();
        }
        this.crlDistributionPoints.add(crlDistributionPointsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The CRL distribution points is an X.509 v3 certificate extension which identifies the location of the CRL from which the revocation of this certificate can be checked. If not set certificate will be issued without CDP. Values are strings.")
    public List<String> getCrlDistributionPoints() {
        return this.crlDistributionPoints;
    }

    public void setCrlDistributionPoints(List<String> crlDistributionPoints) {
        this.crlDistributionPoints = crlDistributionPoints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecSelfSigned v1alpha2IssuerSpecSelfSigned = (V1alpha2IssuerSpecSelfSigned)o;
        return Objects.equals(this.crlDistributionPoints, v1alpha2IssuerSpecSelfSigned.crlDistributionPoints);
    }

    public int hashCode() {
        return Objects.hash(this.crlDistributionPoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecSelfSigned {\n");
        sb.append("    crlDistributionPoints: ").append(this.toIndentedString(this.crlDistributionPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

