/*
 * Decompiled with CFR 0.152.
 */
package io.cert.manager.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Configure an external webhook based DNS01 challenge solver to manage DNS01 challenge records.")
public class V1alpha2IssuerSpecAcmeDns01Webhook {
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private Object config;
    public static final String SERIALIZED_NAME_GROUP_NAME = "groupName";
    @SerializedName(value="groupName")
    private String groupName;
    public static final String SERIALIZED_NAME_SOLVER_NAME = "solverName";
    @SerializedName(value="solverName")
    private String solverName;

    public V1alpha2IssuerSpecAcmeDns01Webhook config(Object config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Additional configuration that should be passed to the webhook apiserver when challenges are processed. This can contain arbitrary JSON data. Secret values should not be specified in this stanza. If secret values are needed (e.g. credentials for a DNS service), you should use a SecretKeySelector to reference a Secret resource. For details on the schema of this field, consult the webhook provider implementation's documentation.")
    public Object getConfig() {
        return this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public V1alpha2IssuerSpecAcmeDns01Webhook groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @ApiModelProperty(required=true, value="The API group name that should be used when POSTing ChallengePayload resources to the webhook apiserver. This should be the same as the GroupName specified in the webhook provider implementation.")
    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public V1alpha2IssuerSpecAcmeDns01Webhook solverName(String solverName) {
        this.solverName = solverName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the solver to use, as defined in the webhook provider implementation. This will typically be the name of the provider, e.g. 'cloudflare'.")
    public String getSolverName() {
        return this.solverName;
    }

    public void setSolverName(String solverName) {
        this.solverName = solverName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha2IssuerSpecAcmeDns01Webhook v1alpha2IssuerSpecAcmeDns01Webhook = (V1alpha2IssuerSpecAcmeDns01Webhook)o;
        return Objects.equals(this.config, v1alpha2IssuerSpecAcmeDns01Webhook.config) && Objects.equals(this.groupName, v1alpha2IssuerSpecAcmeDns01Webhook.groupName) && Objects.equals(this.solverName, v1alpha2IssuerSpecAcmeDns01Webhook.solverName);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.groupName, this.solverName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha2IssuerSpecAcmeDns01Webhook {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    groupName: ").append(this.toIndentedString(this.groupName)).append("\n");
        sb.append("    solverName: ").append(this.toIndentedString(this.solverName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

