/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimBuilder;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimFluentImpl;
import io.kubernetes.client.openapi.models.V1PodTemplateSpec;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecBuilder;
import io.kubernetes.client.openapi.models.V1PodTemplateSpecFluentImpl;
import io.kubernetes.client.openapi.models.V1beta2StatefulSetSpec;
import io.kubernetes.client.openapi.models.V1beta2StatefulSetSpecFluent;
import io.kubernetes.client.openapi.models.V1beta2StatefulSetUpdateStrategy;
import io.kubernetes.client.openapi.models.V1beta2StatefulSetUpdateStrategyBuilder;
import io.kubernetes.client.openapi.models.V1beta2StatefulSetUpdateStrategyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1beta2StatefulSetSpecFluentImpl<A extends V1beta2StatefulSetSpecFluent<A>>
extends BaseFluent<A>
implements V1beta2StatefulSetSpecFluent<A> {
    private String podManagementPolicy;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private V1LabelSelectorBuilder selector;
    private String serviceName;
    private V1PodTemplateSpecBuilder template;
    private V1beta2StatefulSetUpdateStrategyBuilder updateStrategy;
    private List<V1PersistentVolumeClaimBuilder> volumeClaimTemplates;

    public V1beta2StatefulSetSpecFluentImpl() {
    }

    public V1beta2StatefulSetSpecFluentImpl(V1beta2StatefulSetSpec instance) {
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withServiceName(instance.getServiceName());
        this.withTemplate(instance.getTemplate());
        this.withUpdateStrategy(instance.getUpdateStrategy());
        this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
    }

    @Override
    public String getPodManagementPolicy() {
        return this.podManagementPolicy;
    }

    @Override
    public A withPodManagementPolicy(String podManagementPolicy) {
        this.podManagementPolicy = podManagementPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasPodManagementPolicy() {
        return this.podManagementPolicy != null;
    }

    @Override
    public A withNewPodManagementPolicy(String arg1) {
        return this.withPodManagementPolicy(new String(arg1));
    }

    @Override
    public A withNewPodManagementPolicy(StringBuilder arg1) {
        return this.withPodManagementPolicy(new String(arg1));
    }

    @Override
    public A withNewPodManagementPolicy(StringBuffer arg1) {
        return this.withPodManagementPolicy(new String(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    @Deprecated
    public V1LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public V1LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(V1LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new V1LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public V1beta2StatefulSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public V1beta2StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public V1beta2StatefulSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public V1beta2StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1beta2StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    public A withNewServiceName(String arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuilder arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuffer arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    @Deprecated
    public V1PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public V1PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(V1PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new V1PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public V1beta2StatefulSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public V1beta2StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public V1beta2StatefulSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public V1beta2StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new V1PodTemplateSpecBuilder().build());
    }

    @Override
    public V1beta2StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    @Deprecated
    public V1beta2StatefulSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public V1beta2StatefulSetUpdateStrategy buildUpdateStrategy() {
        return this.updateStrategy != null ? this.updateStrategy.build() : null;
    }

    @Override
    public A withUpdateStrategy(V1beta2StatefulSetUpdateStrategy updateStrategy) {
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
        if (updateStrategy != null) {
            this.updateStrategy = new V1beta2StatefulSetUpdateStrategyBuilder(updateStrategy);
            this._visitables.get("updateStrategy").add(this.updateStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUpdateStrategy() {
        return this.updateStrategy != null;
    }

    @Override
    public V1beta2StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
        return new UpdateStrategyNestedImpl();
    }

    @Override
    public V1beta2StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1beta2StatefulSetUpdateStrategy item) {
        return new UpdateStrategyNestedImpl(item);
    }

    @Override
    public V1beta2StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy());
    }

    @Override
    public V1beta2StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : new V1beta2StatefulSetUpdateStrategyBuilder().build());
    }

    @Override
    public V1beta2StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1beta2StatefulSetUpdateStrategy item) {
        return this.withNewUpdateStrategyLike(this.getUpdateStrategy() != null ? this.getUpdateStrategy() : item);
    }

    @Override
    public A addToVolumeClaimTemplates(int index, V1PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();
        }
        V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
        this._visitables.get("volumeClaimTemplates").add(index >= 0 ? index : this._visitables.get("volumeClaimTemplates").size(), builder);
        this.volumeClaimTemplates.add(index >= 0 ? index : this.volumeClaimTemplates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToVolumeClaimTemplates(int index, V1PersistentVolumeClaim item) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();
        }
        V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
        if (index < 0 || index >= this._visitables.get("volumeClaimTemplates").size()) {
            this._visitables.get("volumeClaimTemplates").add(builder);
        } else {
            this._visitables.get("volumeClaimTemplates").set(index, builder);
        }
        if (index < 0 || index >= this.volumeClaimTemplates.size()) {
            this.volumeClaimTemplates.add(builder);
        } else {
            this.volumeClaimTemplates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeClaimTemplates(V1PersistentVolumeClaim ... items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();
        }
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items) {
        if (this.volumeClaimTemplates == null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();
        }
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").add(builder);
            this.volumeClaimTemplates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeClaimTemplates(V1PersistentVolumeClaim ... items) {
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items) {
        for (V1PersistentVolumeClaim item : items) {
            V1PersistentVolumeClaimBuilder builder = new V1PersistentVolumeClaimBuilder(item);
            this._visitables.get("volumeClaimTemplates").remove(builder);
            if (this.volumeClaimTemplates == null) continue;
            this.volumeClaimTemplates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromVolumeClaimTemplates(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        if (this.volumeClaimTemplates == null) {
            return (A)this;
        }
        Iterator<V1PersistentVolumeClaimBuilder> each = this.volumeClaimTemplates.iterator();
        Object visitables = this._visitables.get("volumeClaimTemplates");
        while (each.hasNext()) {
            V1PersistentVolumeClaimBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PersistentVolumeClaim> getVolumeClaimTemplates() {
        return V1beta2StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates);
    }

    @Override
    public List<V1PersistentVolumeClaim> buildVolumeClaimTemplates() {
        return V1beta2StatefulSetSpecFluentImpl.build(this.volumeClaimTemplates);
    }

    @Override
    public V1PersistentVolumeClaim buildVolumeClaimTemplate(int index) {
        return this.volumeClaimTemplates.get(index).build();
    }

    @Override
    public V1PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(0).build();
    }

    @Override
    public V1PersistentVolumeClaim buildLastVolumeClaimTemplate() {
        return this.volumeClaimTemplates.get(this.volumeClaimTemplates.size() - 1).build();
    }

    @Override
    public V1PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        for (V1PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeClaimTemplate(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        for (V1PersistentVolumeClaimBuilder item : this.volumeClaimTemplates) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this._visitables.get("volumeClaimTemplates").removeAll(this.volumeClaimTemplates);
        }
        if (volumeClaimTemplates != null) {
            this.volumeClaimTemplates = new ArrayList<V1PersistentVolumeClaimBuilder>();
            for (V1PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        } else {
            this.volumeClaimTemplates = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeClaimTemplates(V1PersistentVolumeClaim ... volumeClaimTemplates) {
        if (this.volumeClaimTemplates != null) {
            this.volumeClaimTemplates.clear();
        }
        if (volumeClaimTemplates != null) {
            for (V1PersistentVolumeClaim item : volumeClaimTemplates) {
                this.addToVolumeClaimTemplates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplates() {
        return this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty();
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
        return new VolumeClaimTemplatesNestedImpl();
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(V1PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(-1, item);
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index, V1PersistentVolumeClaim item) {
        return new VolumeClaimTemplatesNestedImpl(index, item);
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index) {
        if (this.volumeClaimTemplates.size() <= index) {
            throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
        if (this.volumeClaimTemplates.size() == 0) {
            throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(0, this.buildVolumeClaimTemplate(0));
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
        int index = this.volumeClaimTemplates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    @Override
    public V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<V1PersistentVolumeClaimBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeClaimTemplates.size(); ++i) {
            if (!predicate.apply(this.volumeClaimTemplates.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
        }
        return this.setNewVolumeClaimTemplateLike(index, this.buildVolumeClaimTemplate(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2StatefulSetSpecFluentImpl that = (V1beta2StatefulSetSpecFluentImpl)o;
        if (this.podManagementPolicy != null ? !this.podManagementPolicy.equals(that.podManagementPolicy) : that.podManagementPolicy != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.updateStrategy != null ? !this.updateStrategy.equals(that.updateStrategy) : that.updateStrategy != null) {
            return false;
        }
        return !(this.volumeClaimTemplates != null ? !this.volumeClaimTemplates.equals(that.volumeClaimTemplates) : that.volumeClaimTemplates != null);
    }

    public class VolumeClaimTemplatesNestedImpl<N>
    extends V1PersistentVolumeClaimFluentImpl<V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>>
    implements V1beta2StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,
    Nested<N> {
        private final V1PersistentVolumeClaimBuilder builder;
        private final int index;

        VolumeClaimTemplatesNestedImpl(int index, V1PersistentVolumeClaim item) {
            this.index = index;
            this.builder = new V1PersistentVolumeClaimBuilder(this, item);
        }

        VolumeClaimTemplatesNestedImpl() {
            this.index = -1;
            this.builder = new V1PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(this.index, this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }

    public class UpdateStrategyNestedImpl<N>
    extends V1beta2StatefulSetUpdateStrategyFluentImpl<V1beta2StatefulSetSpecFluent.UpdateStrategyNested<N>>
    implements V1beta2StatefulSetSpecFluent.UpdateStrategyNested<N>,
    Nested<N> {
        private final V1beta2StatefulSetUpdateStrategyBuilder builder;

        UpdateStrategyNestedImpl(V1beta2StatefulSetUpdateStrategy item) {
            this.builder = new V1beta2StatefulSetUpdateStrategyBuilder(this, item);
        }

        UpdateStrategyNestedImpl() {
            this.builder = new V1beta2StatefulSetUpdateStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2StatefulSetSpecFluentImpl.this.withUpdateStrategy(this.builder.build());
        }

        @Override
        public N endUpdateStrategy() {
            return this.and();
        }
    }

    public class TemplateNestedImpl<N>
    extends V1PodTemplateSpecFluentImpl<V1beta2StatefulSetSpecFluent.TemplateNested<N>>
    implements V1beta2StatefulSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final V1PodTemplateSpecBuilder builder;

        TemplateNestedImpl(V1PodTemplateSpec item) {
            this.builder = new V1PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new V1PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2StatefulSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1beta2StatefulSetSpecFluent.SelectorNested<N>>
    implements V1beta2StatefulSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        SelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta2StatefulSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

